/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.jsflibraryconfig;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryConfigPersistData;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryDecorator;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistry;

public class JSFLibraryConfigModelAdapter {
    private IProject project;
    private JSFLibraryRegistry jsfLibReg;
    private List colJSFImplLib;
    private List colJSFCompLib;
    private JSFLibraryConfigPersistData data;
    private JSFLibraryDecorator preSelectedJSFImpl = null;

    public JSFLibraryConfigModelAdapter(IProject project) {
        this.project = project;
        this.jsfLibReg = JSFCorePlugin.getDefault().getJSFLibraryRegistry();
        this.data = new JSFLibraryConfigPersistData(this.project);
        this.preSelectedJSFImpl = this.data.getSelectedJSFLibImplementation();
    }

    public IProject getProject() {
        return this.project;
    }

    public JSFLibraryRegistry getJSFLibraryRegistry() {
        return this.jsfLibReg;
    }

    public List getProjectJSFImplementationLibraries() {
        if (this.colJSFImplLib == null) {
            ArrayList<JSFLibraryDecorator> list = new ArrayList<JSFLibraryDecorator>(Collections.EMPTY_LIST);
            if (this.data.getSelectedJSFLibImplementation() != null) {
                list.add(this.data.getSelectedJSFLibImplementation());
            }
            this.colJSFImplLib = this.buildJSFLibraryDecoratorList(this.jsfLibReg.getImplJSFLibraries(), list);
        }
        return this.colJSFImplLib;
    }

    public List getProjectJSFComponentLibraries() {
        if (this.colJSFCompLib == null) {
            this.colJSFCompLib = this.buildJSFLibraryDecoratorList(this.jsfLibReg.getNonImplJSFLibraries(), this.data.getSelectedJSFLibComponent());
        }
        return this.colJSFCompLib;
    }

    public void saveData(List selJSFLibImpl, List selJSFLibComp) {
        this.data.saveData(selJSFLibImpl, selJSFLibComp);
        this.colJSFImplLib = null;
        this.colJSFCompLib = null;
    }

    public JSFLibraryDecorator getSelectedJSFImplementation() {
        return this.data.getSelectedJSFLibImplementation();
    }

    public JSFLibraryDecorator getPreviousJSFImplementation() {
        return this.preSelectedJSFImpl;
    }

    public List getSelectedJSFComponent() {
        return this.data.getSelectedJSFLibComponent();
    }

    private List buildJSFLibraryDecoratorList(EList wsJSFLibs, List pjJSFLibs) {
        ArrayList<JSFLibraryDecorator> list = new ArrayList<JSFLibraryDecorator>(Collections.EMPTY_LIST);
        JSFLibraryDecorator prjJSFLib = null;
        Iterator it = wsJSFLibs.iterator();
        while (it.hasNext()) {
            JSFLibrary jsfLib = (JSFLibrary)it.next();
            Iterator itPrjLibs = pjJSFLibs.iterator();
            boolean selected = false;
            while (itPrjLibs.hasNext()) {
                prjJSFLib = (JSFLibraryDecorator)itPrjLibs.next();
                selected = prjJSFLib.getID().equals(jsfLib.getID());
                if (selected) break;
            }
            JSFLibraryDecorator newPrjJSFLib = selected && prjJSFLib != null ? prjJSFLib : new JSFLibraryDecorator(jsfLib, false, jsfLib.isDeployed());
            list.add(newPrjJSFLib);
        }
        return list;
    }
}

