/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.context;

import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.plugin.SymbolsPlugin;
import org.eclipse.jst.jsf.context.symbol.source.ISymbolSourceProvider;
import org.eclipse.jst.jsf.context.symbol.source.ISymbolSourceProviderFactory;

public class DTExternalContext {
    public static final String SCOPE_NAME_REQUEST = "request";
    public static final String SCOPE_NAME_SESSION = "session";
    public static final String SCOPE_NAME_APPLICATION = "application";
    private final IFile _jspFile;
    static /* synthetic */ Class class$0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    DTExternalContext(IAdaptable jspFile) {
        IFile file;
        if (jspFile instanceof IFile) {
            this._jspFile = (IFile)jspFile;
            return;
        }
        if (jspFile == null) {
            this._jspFile = null;
            throw new AssertionError((Object)"jspFile must be adapable to an IFile");
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        if ((file = (IFile)jspFile.getAdapter((Class)clazz)) != null) {
            this._jspFile = file;
            return;
        }
        this._jspFile = null;
        throw new AssertionError((Object)"jspFile must be adapable to an IFile");
    }

    public Map getMapForScopeName(String scopeName) {
        if (SCOPE_NAME_REQUEST.equals(scopeName)) {
            return this.getRequestMap();
        }
        if (SCOPE_NAME_SESSION.equals(scopeName)) {
            return this.getSessionMap();
        }
        if (SCOPE_NAME_APPLICATION.equals(scopeName)) {
            return this.getApplicationMap();
        }
        return null;
    }

    public Map getMapForScope(int scopeMask) {
        HashMap<String, ISymbol> map = new HashMap<String, ISymbol>();
        Iterator it = SymbolsPlugin.getSymbolSourceProviders().iterator();
        while (it.hasNext()) {
            ISymbolSourceProviderFactory factory = (ISymbolSourceProviderFactory)it.next();
            ISymbolSourceProvider provider = factory.createInstance(this._jspFile.getProject());
            ISymbol[] symbols = provider.getSymbols((IAdaptable)this._jspFile, scopeMask);
            int i = 0;
            while (i < symbols.length) {
                map.put(symbols[i].getName(), symbols[i]);
                ++i;
            }
        }
        return Collections.unmodifiableMap(map);
    }

    public Map getRequestMap() {
        return this.getMapForScope(1);
    }

    public Map getSessionMap() {
        return this.getMapForScope(2);
    }

    public Map getApplicationMap() {
        return this.getMapForScope(4);
    }

    public void trace(PrintStream stream) {
        String[] scopeNames = new String[]{SCOPE_NAME_REQUEST, SCOPE_NAME_SESSION, SCOPE_NAME_APPLICATION};
        Map[] symbolMaps = new Map[]{this.getRequestMap(), this.getSessionMap(), this.getApplicationMap()};
        int i = 0;
        while (i < scopeNames.length) {
            stream.println("--------------");
            stream.println(String.valueOf(scopeNames[i]) + " Scope:");
            stream.println("--------------");
            Iterator it = symbolMaps[i].values().iterator();
            while (it.hasNext()) {
                ISymbol symbol = (ISymbol)it.next();
                System.out.println(symbol.getName());
            }
            ++i;
        }
    }
}

