/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.metadataprocessors.internal;

import java.util.HashMap;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsf.metadataprocessors.Activator;
import org.eclipse.jst.jsf.metadataprocessors.internal.AbstractMetaDataEnabledType;

public abstract class AbstractMetaDataEnabledTypeRegistry {
    private HashMap typeMap = new HashMap();
    private String ext_pt_id;

    public AbstractMetaDataEnabledTypeRegistry(String extPtId) {
        this.ext_pt_id = extPtId;
        this.readRegistry();
    }

    protected void registerType(String bundleID, String id, String klass, String runtimeType) {
        AbstractMetaDataEnabledType atype = new AbstractMetaDataEnabledType(bundleID, id, klass);
        if (!this.typeMap.containsKey(atype.getTypeID())) {
            this.typeMap.put(atype.getTypeID(), atype);
        } else {
            Activator.log(4, "Duplicate RuntimeTypeId being registered from " + this.ext_pt_id + ": " + atype.getTypeID());
        }
    }

    public AbstractMetaDataEnabledType getType(String id) {
        if (this.typeMap.containsKey(id)) {
            return (AbstractMetaDataEnabledType)this.typeMap.get(id);
        }
        return null;
    }

    protected void readRegistry() {
        try {
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jst.jsf.metadataprocessors", this.ext_pt_id);
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension ext = extensions[i];
                int j = 0;
                while (j < ext.getConfigurationElements().length) {
                    String bundleId = ext.getConfigurationElements()[j].getContributor().getName();
                    String id = ext.getConfigurationElements()[j].getAttribute("id");
                    String klass = ext.getConfigurationElements()[j].getAttribute("class");
                    String runtimeType = ext.getConfigurationElements()[j].getAttribute("runtime-type");
                    if (klass == null || klass.trim().equals("")) {
                        klass = this.getDefaultClassName();
                    }
                    this.registerType(bundleId, id, klass, runtimeType);
                    ++j;
                }
                ++i;
            }
        }
        catch (InvalidRegistryObjectException e) {
            Activator.log((Exception)((Object)e), "Unable to read org.eclipse.jst.jsf.metadataprocessors" + this.ext_pt_id + " registry");
        }
    }

    protected abstract String getDefaultClassName();
}

