package com.leagueplanet.dao.example;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import com.leagueplanet.dao.LeagueDAO;
import com.leagueplanet.model.Event;
import com.leagueplanet.model.Game;
import com.leagueplanet.model.League;
import com.leagueplanet.model.Location;
import com.leagueplanet.model.Player;
import com.leagueplanet.model.Schedule;
import com.leagueplanet.model.Score;
import com.leagueplanet.model.Team;

public class IceHockeyDOAImpl implements LeagueDAO {

	// singleton DAO
	private static IceHockeyDOAImpl leagueDAO = null;

	// in-memory copy of data
	private HashMap leagues = new HashMap();

	private HashMap schedules = new HashMap();

	private HashMap locations = new HashMap();

	private HashMap teams = new HashMap();

	private HashMap games = new HashMap();

	private HashMap events = new HashMap();

	private HashMap players = new HashMap();

	public Set getSchedulesForLeague(String league) {
		// TODO Auto-generated method stub
		return null;
	}

	public Set findLeaguesWithName(String name) {

		Set results = new HashSet();
		Iterator leagueIterator = leagues.values().iterator();
		while (leagueIterator.hasNext()) {
			League aLeague = (League) leagueIterator.next();
			if (name.equals(aLeague.getName()))
				results.add(aLeague);
		}
		return results;
	}

	public void save(League newLeague) {
		// TODO Auto-generated method stub

	}

	public static LeagueDAO getLeagueDAO() {
		if (leagueDAO == null) {
			leagueDAO = new IceHockeyDOAImpl();
			leagueDAO.init();
		}

		return leagueDAO;
	}

	private void init() {

		League league1 = new League(1, "Rosehill Girls Hockey League");
		leagues.put(new Long(1), league1);

		Location location1 = new Location(1, "Hillview High School",
				"Canada/Eastern");
		locations.put(new Long(1), location1);

		Location location2 = new Location(2, "Maple Community Centre",
				"Canada/Eastern");
		locations.put(new Long(2), location2);

		Team team1 = new Team(1, "Ladybugs");
		teams.put(new Long(1), team1);
		league1.getTeams().add(team1);

		Team team2 = new Team(2, "Vixens");
		teams.put(new Long(2), team2);
		league1.getTeams().add(team2);

		Team team3 = new Team(3, "Snowflakes");
		teams.put(new Long(3), team3);
		league1.getTeams().add(team3);

		Team team4 = new Team(4, "Foxes");
		teams.put(new Long(4), team4);
		league1.getTeams().add(team4);

		Schedule schedule1 = new Schedule(1, "2005-2006 Regular Season");
		schedules.put(new Long(1), schedule1);
		schedule1.setLeague(league1);
		league1.getSchedules().add(schedule1);

		Game game1 = new Game(1, "2006-01-07", "19:00:00");
		events.put(new Long(1), game1);
		games.put(new Long(1), game1);
		game1.setLocation(location1);
		game1.setVisitor(team1);
		game1.setHome(team2);
		game1.setScore(new Score(3, 7));
		game1.setSchedule(schedule1);
		schedule1.getEvents().add(game1);

		Game game2 = new Game(2, "2006-01-07", "21:00:00");
		events.put(new Long(2), game2);
		games.put(new Long(2), game2);
		game2.setLocation(location1);
		game2.setVisitor(team3);
		game2.setHome(team4);
		game2.setScore(new Score(5, 2));
		game2.setSchedule(schedule1);
		schedule1.getEvents().add(game2);

		Game game3 = new Game(3, "2006-01-08", "19:30:00");
		events.put(new Long(3), game3);
		games.put(new Long(3), game3);
		game3.setLocation(location2);
		game3.setVisitor(team2);
		game3.setHome(team4);
		game3.setScore(new Score(3, 5));
		game3.setSchedule(schedule1);
		schedule1.getEvents().add(game3);

		Game game4 = new Game(4, "2006-01-08", "21:30:00");
		events.put(new Long(4), game4);
		games.put(new Long(4), game4);
		game4.setLocation(location2);
		game4.setVisitor(team3);
		game4.setHome(team1);
		game4.setScore(new Score(0, 4));
		game4.setSchedule(schedule1);
		schedule1.getEvents().add(game4);

		Game game5 = new Game(5, "2006-01-14", "19:00:00");
		events.put(new Long(5), game5);
		games.put(new Long(5), game5);
		game5.setLocation(location1);
		game5.setVisitor(team3);
		game5.setHome(team2);
		game5.setScore(new Score(10, 4));
		game5.setSchedule(schedule1);
		schedule1.getEvents().add(game5);

		Game game6 = new Game(6, "2006-01-21", "19:00:00");
		events.put(new Long(6), game6);
		games.put(new Long(6), game6);
		game6.setLocation(location1);
		game6.setVisitor(team4);
		game6.setHome(team1);
		game6.setScore(new Score(3, 3));
		game6.setSchedule(schedule1);
		schedule1.getEvents().add(game6);

		Game game7 = new Game(7, "2006-01-22", "19:30:00");
		events.put(new Long(7), game7);
		games.put(new Long(7), game7);
		game7.setLocation(location2);
		game7.setVisitor(team3);
		game7.setHome(team2);
		game7.setScore(new Score(2, 6));
		game7.setSchedule(schedule1);
		schedule1.getEvents().add(game7);
	}

	public Event findEvent(long id) {
		Object x = events.get(new Long(id));
		return (Event) x;
	}

	public Game findGame(long id) {
		Object x = games.get(new Long(id));
		return (Game) x;
	}

	public League findLeague(long id) {
		Object x = leagues.get(new Long(id));
		return (League) x;
	}

	public Location findLocation(long id) {
		Object x = locations.get(new Long(id));
		return (Location) x;
	}

	public Schedule findSchedule(long id) {
		Object x = schedules.get(new Long(id));
		return (Schedule) x;
	}

	public Team findTeam(long id) {
		Object x = teams.get(new Long(id));
		return (Team) x;
	}

	public Player findPlayer(long id) {
		Object x = players.get(new Long(id));
		return (Player) x;
	}
}
