/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import java.lang.reflect.Method;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractBaseTableRendering;
import org.eclipse.debug.ui.memory.AbstractTableRendering;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.PlatformUI;

public class ResetToBaseAddressAction
extends Action {
    private final AbstractBaseTableRendering fRendering;

    public ResetToBaseAddressAction(AbstractBaseTableRendering rendering) {
        this.fRendering = rendering;
        this.setText(DebugUIMessages.ResetMemoryBlockAction_title);
        this.setToolTipText(DebugUIMessages.ResetMemoryBlockAction_tootip);
        this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_RESET_MEMORY"));
        this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_LCL_RESET_MEMORY"));
        this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_RESET_MEMORY"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.ResetBaseAddressContextAction_context");
    }

    public void run() {
        block8: {
            Class<?> renderingClass = this.fRendering.getClass();
            try {
                Method method = renderingClass.getMethod("reset", new Class[0]);
                if (!method.getDeclaringClass().equals(AbstractTableRendering.class)) break block8;
                try {
                    this.fRendering.resetRendering();
                }
                catch (DebugException e) {
                    MemoryViewUtil.openError(DebugUIMessages.AbstractTableRendering_12, DebugUIMessages.AbstractTableRendering_13, (Exception)((Object)e));
                }
                return;
            }
            catch (SecurityException method) {
            }
            catch (NoSuchMethodException e) {
                try {
                    this.fRendering.resetRendering();
                }
                catch (DebugException e1) {
                    MemoryViewUtil.openError(DebugUIMessages.AbstractTableRendering_12, DebugUIMessages.AbstractTableRendering_13, e);
                }
            }
        }
        if (this.fRendering instanceof AbstractTableRendering) {
            ((AbstractTableRendering)this.fRendering).reset();
        }
    }
}

