/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.provisional.format;

import java.util.Vector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatContraints;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.format.NodeFormatter;
import org.w3c.dom.Node;

public class TextNodeFormatter
extends NodeFormatter {
    private static final String CR = "\r";
    private static final String DELIMITERS = " \t\n\r\f";
    private static final String EMPTY_STRING = "";
    private static final String FF = "\f";
    private static final String LF = "\n";
    private static final String SPACE = " ";
    private static final String TAB = "\t";

    private String compressSpaces(String string, IStructuredFormatContraints formatContraints) {
        String[] stringArray = null;
        boolean clearAllBlankLines = formatContraints.getClearAllBlankLines();
        stringArray = clearAllBlankLines ? StringUtils.asArray((String)string) : StringUtils.asArray((String)string, (String)DELIMITERS, (boolean)true);
        StringBuffer compressedString = new StringBuffer();
        if (stringArray.length > 0) {
            boolean cr = false;
            boolean lf = false;
            boolean cr2 = false;
            boolean nonSpace = true;
            if (stringArray[0].compareTo(CR) == 0) {
                cr = true;
            } else if (stringArray[0].compareTo(LF) == 0) {
                lf = true;
            } else if (stringArray[0].compareTo(SPACE) != 0 && stringArray[0].compareTo(TAB) != 0 && stringArray[0].compareTo(FF) != 0) {
                compressedString.append(stringArray[0]);
                nonSpace = true;
            }
            int i = 1;
            while (i < stringArray.length) {
                if (stringArray[i].compareTo(CR) == 0) {
                    if (cr && lf) {
                        if (nonSpace) {
                            compressedString.append("\r\n");
                            nonSpace = false;
                        }
                        compressedString.append(stringArray[i]);
                        cr2 = true;
                    } else if (cr) {
                        if (nonSpace) {
                            compressedString.append(CR);
                            nonSpace = false;
                        }
                        compressedString.append(stringArray[i]);
                        cr2 = true;
                    } else {
                        cr = true;
                    }
                } else if (stringArray[i].compareTo(LF) == 0) {
                    if (cr && lf && cr2) {
                        compressedString.append(stringArray[i]);
                    } else if (lf) {
                        if (nonSpace) {
                            compressedString.append(LF);
                            nonSpace = false;
                        }
                        compressedString.append(stringArray[i]);
                    } else {
                        lf = true;
                    }
                } else if (stringArray[i].compareTo(SPACE) != 0 && stringArray[i].compareTo(TAB) != 0 && stringArray[i].compareTo(FF) != 0) {
                    if (compressedString.length() > 0) {
                        compressedString.append(SPACE);
                    }
                    compressedString.append(stringArray[i]);
                    cr = false;
                    lf = false;
                    cr2 = false;
                    nonSpace = true;
                }
                ++i;
            }
        }
        return compressedString.toString();
    }

    @Override
    protected void formatNode(IDOMNode node, IStructuredFormatContraints formatContraints) {
        if (formatContraints.getInPreserveSpaceElement()) {
            return;
        }
        if (node != null) {
            IStructuredDocument doc = node.getStructuredDocument();
            int lineWidth = this.getFormatPreferences().getLineWidth();
            int currentAvailableLineWidth = this.computeAvailableLineWidth(doc, node.getStartOffset(), lineWidth);
            String nodeText = this.getNodeText(node);
            String compressedText = this.compressSpaces(nodeText, formatContraints);
            IDOMNode parentNode = (IDOMNode)node.getParentNode();
            if (this.enoughSpace(parentNode, currentAvailableLineWidth, compressedText) && this.noSiblingsAndNoFollowingComment(node) && !this.firstStructuredDocumentRegionContainsLineDelimiters(parentNode) || node.getStartOffset() == 0) {
                this.handleNoReflow(node, doc, compressedText, parentNode);
            } else {
                String theString;
                String nodeIndentation = formatContraints.getCurrentIndent();
                currentAvailableLineWidth = lineWidth - this.getIndentationLength(nodeIndentation);
                Vector vector = this.reflowText(compressedText, currentAvailableLineWidth);
                int vectorSize = vector.size();
                StringBuffer reflowedTextBuffer = new StringBuffer();
                String lineDelimiter = this.getLineDelimiter(doc, node.getStartOffset());
                if (vectorSize > 0) {
                    Node previousSibling;
                    boolean allowWhitespace = true;
                    if (!(nodeText.length() != 0 && Character.isWhitespace(nodeText.charAt(0)) || (previousSibling = node.getPreviousSibling()) == null || previousSibling.getNodeType() != 5 && previousSibling.getNodeType() != 4)) {
                        allowWhitespace = false;
                    }
                    theString = (String)vector.get(0);
                    if (allowWhitespace) {
                        reflowedTextBuffer.append(lineDelimiter);
                        if (theString.trim().length() > 0) {
                            reflowedTextBuffer.append(nodeIndentation).append(theString);
                        }
                    } else {
                        reflowedTextBuffer.append(theString);
                    }
                }
                int i = 1;
                while (i < vectorSize) {
                    theString = (String)vector.get(i);
                    if (theString.trim().length() > 0) {
                        reflowedTextBuffer.append(lineDelimiter).append(nodeIndentation).append(theString);
                    } else {
                        reflowedTextBuffer.append(lineDelimiter);
                    }
                    ++i;
                }
                String reflowedText = reflowedTextBuffer.toString();
                if (node.getNextSibling() == null) {
                    if (!this.isEndTagMissing(parentNode) && !reflowedText.endsWith(lineDelimiter + (nodeIndentation = this.getNodeIndent(parentNode)))) {
                        reflowedText = StringUtils.appendIfNotEndWith((String)reflowedText, (String)lineDelimiter);
                        reflowedText = StringUtils.appendIfNotEndWith((String)reflowedText, (String)nodeIndentation);
                    }
                } else if (!reflowedText.endsWith(lineDelimiter + nodeIndentation)) {
                    Node nextSibling = node.getNextSibling();
                    if (nextSibling.getNodeType() == 8) {
                        boolean currentTextEndsWithLineDelimiter;
                        int indexOfLastLineDelimiter = StringUtils.indexOfLastLineDelimiter((String)nodeText);
                        boolean bl = currentTextEndsWithLineDelimiter = indexOfLastLineDelimiter != -1;
                        if (currentTextEndsWithLineDelimiter) {
                            currentTextEndsWithLineDelimiter = StringUtils.indexOfNonblank((String)nodeText, (int)indexOfLastLineDelimiter) == -1;
                        }
                        String nodeValue = nextSibling.getNodeValue();
                        boolean multiLineComment = StringUtils.containsLineDelimiter((String)nodeValue);
                        if (currentTextEndsWithLineDelimiter || multiLineComment) {
                            reflowedText = StringUtils.appendIfNotEndWith((String)reflowedText, (String)lineDelimiter);
                            reflowedText = StringUtils.appendIfNotEndWith((String)reflowedText, (String)nodeIndentation);
                        }
                    } else if (nextSibling.getNodeType() == 5 || nextSibling.getNodeType() == 4) {
                        int textLength = nodeText.length();
                        if (textLength > 0 && Character.isWhitespace(nodeText.charAt(textLength - 1))) {
                            reflowedText = StringUtils.appendIfNotEndWith((String)reflowedText, (String)lineDelimiter);
                            reflowedText = StringUtils.appendIfNotEndWith((String)reflowedText, (String)nodeIndentation);
                        }
                    } else {
                        reflowedText = StringUtils.appendIfNotEndWith((String)reflowedText, (String)lineDelimiter);
                        reflowedText = StringUtils.appendIfNotEndWith((String)reflowedText, (String)nodeIndentation);
                    }
                }
                this.replaceNodeValue(node, reflowedText);
            }
        }
    }

    private void handleNoReflow(IDOMNode node, IStructuredDocument doc, String compressedText, IDOMNode parentNode) {
        if (this.isEndTagMissing(parentNode)) {
            parentNode = (IDOMNode)parentNode.getParentNode();
            while (this.isEndTagMissing(parentNode)) {
                parentNode = (IDOMNode)parentNode.getParentNode();
            }
            String nodeIndentation = this.getNodeIndent(parentNode);
            String lineDelimiter = this.getLineDelimiter(doc, node.getStartOffset());
            if (!compressedText.endsWith(lineDelimiter + nodeIndentation)) {
                compressedText = StringUtils.appendIfNotEndWith((String)compressedText, (String)lineDelimiter);
                compressedText = StringUtils.appendIfNotEndWith((String)compressedText, (String)nodeIndentation);
            }
        }
        if (parentNode != null && parentNode.getNodeType() == 9 && node.getNodeValue().length() > 0 && node.getNodeValue().trim().length() == 0 && (node.getPreviousSibling() == null || node.getNextSibling() == null)) {
            compressedText = EMPTY_STRING;
        }
        this.replaceNodeValue(node, compressedText);
    }

    private boolean noSiblingsAndNoFollowingComment(IDOMNode node) {
        IDOMNode nextSibling = (IDOMNode)node.getNextSibling();
        return !this.nodeHasSiblings(node) || this.noLineDelimiter(node) && this.isComment(nextSibling) && this.noLineDelimiter(nextSibling);
    }

    private boolean isComment(IDOMNode node) {
        boolean result = false;
        if (node != null) {
            result = node.getNodeType() == 8;
        }
        return result;
    }

    private boolean noLineDelimiter(IDOMNode node) {
        boolean result = false;
        if (node != null) {
            result = !StringUtils.containsLineDelimiter((String)node.getNodeValue());
        }
        return result;
    }

    private boolean enoughSpace(IDOMNode parentNode, int currentAvailableLineWidth, String compressedText) {
        int parentEndTagLength = parentNode.getNodeName().length() + 3;
        return compressedText.length() <= currentAvailableLineWidth - parentEndTagLength && !StringUtils.containsLineDelimiter((String)compressedText);
    }

    protected Vector reflowText(String text, int availableWidth) {
        String[] stringArray = null;
        boolean clearAllBlankLines = this.getFormatPreferences().getClearAllBlankLines();
        stringArray = clearAllBlankLines ? StringUtils.asArray((String)text) : StringUtils.asArray((String)text, (String)DELIMITERS, (boolean)true);
        Vector<String> output = new Vector<String>();
        if (stringArray != null && stringArray.length > 0) {
            StringBuffer buffer = new StringBuffer();
            if (stringArray[0].compareTo(CR) != 0) {
                buffer.append(stringArray[0]);
            }
            int bufferLength = stringArray[0].toString().length();
            boolean cr = stringArray[0].compareTo(CR) == 0;
            int i = 1;
            while (i < stringArray.length) {
                String eachString = stringArray[i];
                if (eachString.compareTo(SPACE) != 0 && eachString.compareTo(TAB) != 0 && eachString.compareTo(FF) != 0) {
                    if (bufferLength + 1 + eachString.length() > availableWidth || eachString.compareTo(CR) == 0 || eachString.compareTo(LF) == 0) {
                        if (eachString.compareTo(LF) != 0 || !cr) {
                            output.add(buffer.toString());
                            buffer = new StringBuffer();
                            bufferLength = 0;
                        }
                        cr = eachString.compareTo(CR) == 0;
                    } else if (buffer.toString().trim().length() > 0) {
                        buffer.append(SPACE);
                        ++bufferLength;
                    }
                    if (eachString.compareTo(CR) != 0 && eachString.compareTo(LF) != 0) {
                        buffer.append(eachString);
                        bufferLength += eachString.length();
                    }
                }
                ++i;
            }
            output.add(buffer.toString());
        } else {
            output.add(text);
        }
        return output;
    }

    private String getLineDelimiter(IStructuredDocument doc, int nodeOffset) {
        int line = doc.getLineOfOffset(nodeOffset);
        String lineDelimiter = doc.getLineDelimiter();
        try {
            if (line > 0) {
                lineDelimiter = doc.getLineDelimiter(line - 1);
            }
        }
        catch (BadLocationException e) {
            Logger.log(1, e.getMessage());
        }
        if (lineDelimiter == null) {
            lineDelimiter = doc.getLineDelimiter();
        }
        return lineDelimiter;
    }

    private int computeAvailableLineWidth(IStructuredDocument doc, int nodeOffset, int lineWidth) {
        int currentAvailableLineWidth = 0;
        try {
            int lineOffset = doc.getLineInformationOfOffset(nodeOffset).getOffset();
            String text = doc.get(lineOffset, nodeOffset - lineOffset);
            int usedWidth = this.getIndentationLength(text);
            currentAvailableLineWidth = lineWidth - usedWidth;
        }
        catch (BadLocationException e) {
            Logger.log(1, e.getMessage());
        }
        return currentAvailableLineWidth;
    }
}

