/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model;

import io.swagger.v3.oas.annotations.media.Schema;

public interface DataProvider {
    @Schema(description="The human readable name")
    public String getName();

    @Schema(description="The output provider's ID")
    public String getId();

    @Schema(description="Type of data returned by this output. Serves as a hint to determine what kind of view should be used for this output (ex. XY, Time Graph, Table, etc..). Providers of type TREE_TIME_XY and TIME_GRAPH can be grouped under the same time axis. Providers of type DATA_TREE only provide a tree with columns and don't have any XY nor time graph data associated with it.")
    public ProviderType getType();

    @Schema(description="Describes the output provider's features")
    public String getDescription();

    public static enum ProviderType {
        TABLE,
        TREE_TIME_XY,
        TIME_GRAPH,
        DATA_TREE;

    }
}

