/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.parsers.custom;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.core.parsers.custom.CustomExtraFieldsAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfBaseAspects;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfContentFieldAspect;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTraceDefinition;

public class CustomEventAspects {
    private CustomEventAspects() {
    }

    public static @NonNull Iterable<ITmfEventAspect<?>> generateAspects(CustomTraceDefinition definition) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (CustomTraceDefinition.OutputColumn output : definition.outputs) {
            if (output.tag.equals((Object)CustomTraceDefinition.Tag.TIMESTAMP) && (definition.timeStampOutputFormat == null || definition.timeStampOutputFormat.isEmpty())) {
                builder.add(TmfBaseAspects.getTimestampAspect());
                fieldNames.add(output.name);
                continue;
            }
            if (output.tag.equals((Object)CustomTraceDefinition.Tag.EVENT_TYPE)) {
                builder.add(TmfBaseAspects.getEventTypeAspect());
                fieldNames.add(output.name);
                continue;
            }
            if (output.tag.equals((Object)CustomTraceDefinition.Tag.EXTRA_FIELD_NAME) || output.tag.equals((Object)CustomTraceDefinition.Tag.EXTRA_FIELD_VALUE)) continue;
            if (output.tag.equals((Object)CustomTraceDefinition.Tag.EXTRA_FIELDS)) {
                builder.add((Object)new CustomExtraFieldsAspect());
                continue;
            }
            builder.add((Object)new TmfContentFieldAspect(output.name, output.name));
            fieldNames.add(output.name);
        }
        return builder.build();
    }
}

