/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.context;

import java.io.IOException;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.Activator;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.context.BinaryFTraceLocation;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.context.BinaryFTraceLocationInfo;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.iterator.BinaryFTraceIterator;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.event.GenericFtraceEvent;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.trace.BinaryFTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;

public class BinaryFTraceContext
implements ITmfContext {
    private BinaryFTraceLocation fCurLocation;
    private long fCurRank;
    private final BinaryFTrace fTrace;
    private BinaryFTraceIterator fIterator;

    public BinaryFTraceContext(BinaryFTrace trace) {
        this.fTrace = trace;
        this.fCurLocation = new BinaryFTraceLocation(new BinaryFTraceLocationInfo(0L, 0L));
    }

    public long getRank() {
        return this.fCurRank;
    }

    public synchronized ITmfLocation getLocation() {
        return this.fCurLocation;
    }

    public synchronized boolean hasValidRank() {
        return this.fCurLocation.getLocationInfo().compareTo((BinaryFTraceLocationInfo)BinaryFTraceLocation.INVALID_LOCATION.getLocationInfo()) != 0;
    }

    public synchronized void setLocation(ITmfLocation location) {
        try {
            if (location instanceof BinaryFTraceLocation) {
                BinaryFTraceLocation ctfLocation = (BinaryFTraceLocation)location;
                if (location.getLocationInfo().equals(BinaryFTraceLocation.INVALID_LOCATION.getLocationInfo())) {
                    this.fCurLocation = ctfLocation;
                } else {
                    BinaryFTraceIterator iterator = this.getIterator();
                    if (iterator == null) {
                        return;
                    }
                    iterator.seek(ctfLocation.getLocationInfo());
                    this.fCurLocation = iterator.getLocation();
                }
            } else {
                this.fCurLocation = null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Activator.getInstance().logError("An error occured while setting the location for binary FTrace context.");
        }
    }

    public void setRank(long rank) {
        this.fCurRank = rank;
    }

    public void increaseRank() {
        if (this.hasValidRank()) {
            ++this.fCurRank;
        }
    }

    public BinaryFTrace getTrace() {
        return this.fTrace;
    }

    public synchronized GenericFtraceEvent getCurrentEvent() {
        try {
            BinaryFTraceIterator iterator = this.getIterator();
            return iterator == null ? null : iterator.getCurrentEvent();
        }
        catch (Exception ex) {
            Activator.getInstance().logError(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public synchronized boolean advance() {
        BinaryFTraceIterator iterator;
        BinaryFTraceLocationInfo curLocationData;
        block5: {
            try {
                curLocationData = this.fCurLocation.getLocationInfo();
                iterator = this.getIterator();
                if (iterator != null) break block5;
                return false;
            }
            catch (Exception ex) {
                Activator.getInstance().logError(ex.getMessage(), (Throwable)ex);
                return false;
            }
        }
        boolean advanceSuccess = iterator.advance();
        GenericFtraceEvent currentEvent = iterator.getCurrentEvent();
        if (currentEvent != null) {
            long timestampValue = iterator.getCurrentTimestamp();
            this.fCurLocation = curLocationData.getTimestamp() == timestampValue ? new BinaryFTraceLocation(timestampValue, curLocationData.getIndex() + 1L) : new BinaryFTraceLocation(timestampValue, 0L);
        } else {
            this.fCurLocation = new BinaryFTraceLocation(BinaryFTraceLocation.INVALID_LOCATION);
        }
        return advanceSuccess;
    }

    public synchronized boolean seek(long timestamp) {
        BinaryFTraceIterator iterator;
        block3: {
            try {
                iterator = this.getIterator();
                if (iterator != null) break block3;
                return false;
            }
            catch (Exception ex) {
                Activator.getInstance().logError(ex.getMessage(), (Throwable)ex);
                return false;
            }
        }
        boolean seekSuccess = iterator.seek(timestamp);
        this.fCurLocation = iterator.getLocation();
        return seekSuccess;
    }

    public synchronized boolean seek(BinaryFTraceLocationInfo location) {
        try {
            this.fCurLocation = new BinaryFTraceLocation(location);
            BinaryFTraceIterator iterator = this.getIterator();
            return iterator == null ? false : iterator.seek(location);
        }
        catch (Exception ex) {
            Activator.getInstance().logError(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    private BinaryFTraceIterator getIterator() throws IOException {
        if (this.fIterator == null) {
            this.fIterator = (BinaryFTraceIterator)this.fTrace.createIterator();
            ITmfLocation seekLocation = this.getLocation();
            if (seekLocation != null) {
                BinaryFTraceLocationInfo location = (BinaryFTraceLocationInfo)seekLocation.getLocationInfo();
                this.fIterator.seek(location);
            }
        }
        return this.fIterator;
    }

    public void dispose() {
    }
}

