/*******************************************************************************
 * Copyright (c) 2005, 2023 Polarion Software and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * https://www.eclipse.org/legal/epl-2.0
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Andrej Zachar - Initial API and implementation
 *    Alexander Fedorov (ArSysOp) - ongoing support
 *******************************************************************************/

package org.eclipse.team.svn.ui.extension.impl;

import org.eclipse.team.svn.ui.extension.factory.ICommentView;
import org.eclipse.team.svn.ui.extension.factory.IHistoryViewFactory;

/**
 * Default team history components factory
 * 
 * @author Andrej Zachar
 */
public class DefaultHistoryViewFactory implements IHistoryViewFactory {

	@Override
	public ICommentView getCommentView() {
		return new DefaultCommentView();
	}

}
