/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryResourceProvider;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class LocateResourceURLInHistoryOperation
extends AbstractRepositoryOperation
implements IRepositoryResourceProvider {
    protected IRepositoryResource[] converted;

    public LocateResourceURLInHistoryOperation(IRepositoryResource[] resources) {
        super("Operation_LocateURLInHistory", SVNMessages.class, resources);
    }

    public LocateResourceURLInHistoryOperation(IRepositoryResourceProvider provider) {
        super("Operation_LocateURLInHistory", SVNMessages.class, provider);
    }

    @Override
    public IRepositoryResource[] getRepositoryResources() {
        return this.converted;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryResource[] resources = this.operableData();
        this.converted = new IRepositoryResource[resources.length];
        System.arraycopy(resources, 0, this.converted, 0, resources.length);
        int i = 0;
        while (i < resources.length && !monitor.isCanceled()) {
            int idx = i;
            ProgressMonitorUtility.setTaskInfo(monitor, this, resources[i].getUrl());
            if (this.converted[i].getSelectedRevision().getKind() == SVNRevision.Kind.NUMBER) {
                this.protectStep(monitor1 -> {
                    IRepositoryResource iRepositoryResource = this.processEntry(this.converted[idx], monitor1);
                }, monitor, resources.length);
            }
            ++i;
        }
    }

    protected IRepositoryResource processEntry(IRepositoryResource current, IProgressMonitor monitor) throws Exception {
        IRepositoryLocation location = current.getRepositoryLocation();
        ISVNConnector proxy = location.acquireSVNProxy();
        try {
            SVNEntryRevisionReference entry = SVNUtility.getEntryRevisionReference(current);
            entry = SVNUtility.convertRevisionReference(proxy, entry, new SVNProgressMonitor(this, monitor, null));
            IRepositoryResource retVal = current instanceof IRepositoryFile ? location.asRepositoryFile(entry.path, false) : location.asRepositoryContainer(entry.path, false);
            retVal.setPegRevision(entry.pegRevision);
            retVal.setSelectedRevision(entry.revision);
            IRepositoryResource iRepositoryResource = retVal;
            return iRepositoryResource;
        }
        finally {
            location.releaseSVNProxy(proxy);
        }
    }
}

