/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNNotificationCallback;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.operation.IRevisionProvider;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class CreateFileOperation
extends AbstractRepositoryOperation
implements IRevisionProvider {
    protected String path;
    protected String message;
    protected String[] fileNames;
    protected IRevisionProvider.RevisionPair[] revisionPair;

    public CreateFileOperation(IRepositoryResource resource, String path, String message, String[] fileNames) {
        super("Operation_CreateFile", SVNMessages.class, new IRepositoryResource[]{resource});
        this.path = path;
        this.message = message;
        this.fileNames = fileNames;
    }

    @Override
    public IRevisionProvider.RevisionPair[] getRevisions() {
        return this.revisionPair;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryResource resource = this.operableData()[0];
        IRepositoryLocation location = resource.getRepositoryLocation();
        this.revisionPair = new IRevisionProvider.RevisionPair[1];
        ISVNConnector proxy = location.acquireSVNProxy();
        ISVNNotificationCallback notify = info -> {
            if (info.revision != -1L) {
                String[] path = new String[]{resource.getUrl()};
                this.revisionPair[0] = new IRevisionProvider.RevisionPair(info.revision, path, location);
                String message = BaseMessages.format(SVNMessages.Console_CommittedRevision, new String[]{String.valueOf(info.revision)});
                this.writeToConsole(1, message);
            }
        };
        try {
            SVNUtility.addSVNNotifyListener(proxy, notify);
            String[] stringArray = this.fileNames;
            int n = this.fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                String[] currentFile = new String[]{fileName};
                this.protectStep(monitor1 -> {
                    String path = FileUtility.normalizePath(this.path + "/" + currentFile[0]);
                    String url = resource.getUrl() + "/" + currentFile[0];
                    this.writeToConsole(0, "svn import \"" + path + "\" \"" + url + "\" -m \"" + this.message + "\"" + ISVNConnector.Options.asCommandLine(4352L) + FileUtility.getUsernameParam(location.getUsername()) + " -N\n");
                    proxy.importTo(path, SVNUtility.encodeURL(url), this.message, SVNDepth.FILES, 4352L, null, null, new SVNProgressMonitor(this, monitor1, null));
                }, monitor, this.fileNames.length);
                ++n2;
            }
        }
        finally {
            SVNUtility.removeSVNNotifyListener(proxy, notify);
            location.releaseSVNProxy(proxy);
        }
    }
}

