/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local.property;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.operation.local.property.IPropertyProvider;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;

public class SetMultiPropertiesOperation
extends AbstractWorkingCopyOperation {
    protected IPropertyProvider propertyProvider;
    protected int depth;
    protected IStateFilter filter;

    public SetMultiPropertiesOperation(IResourceProvider resourceProvider, IPropertyProvider propertyProvider, IStateFilter filter, int depth) {
        super("Operation_SetMultiProperties", SVNMessages.class, resourceProvider);
        this.propertyProvider = propertyProvider;
        this.depth = depth;
        this.filter = filter != null ? filter : IStateFilter.SF_VERSIONED;
    }

    public SetMultiPropertiesOperation(IResource[] resources, IPropertyProvider propertyProvider, IStateFilter filter, int depth) {
        super("Operation_SetMultiProperties", SVNMessages.class, resources);
        this.propertyProvider = propertyProvider;
        this.depth = depth;
        this.filter = filter != null ? filter : IStateFilter.SF_VERSIONED;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] resources = this.operableData();
        int i = 0;
        while (i < resources.length && !monitor.isCanceled()) {
            IResource current = resources[i];
            IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(current);
            ISVNConnector proxy = location.acquireSVNProxy();
            try {
                this.protectStep(monitor1 -> FileUtility.visitNodes(current, resource -> {
                    SVNProperty[] properties;
                    if (monitor1.isCanceled() || FileUtility.isNotSupervised(resource)) {
                        return false;
                    }
                    ILocalResource local = SVNRemoteStorage.instance().asLocalResourceAccessible(resource);
                    if (this.filter.accept(local) && (properties = this.propertyProvider.getProperties(resource)) != null) {
                        this.processResource(proxy, resource, properties, monitor1);
                    }
                    return this.filter.allowsRecursion(local);
                }, this.depth), monitor, resources.length);
            }
            finally {
                location.releaseSVNProxy(proxy);
            }
            ++i;
        }
    }

    protected void processResource(ISVNConnector proxy, IResource current, SVNProperty[] properties, IProgressMonitor monitor) {
        ProgressMonitorUtility.setTaskInfo(monitor, this, current.getFullPath().toString());
        String wcPath = FileUtility.getWorkingCopyPath(current);
        int i = 0;
        while (i < properties.length && !monitor.isCanceled()) {
            SVNProperty property = properties[i];
            this.protectStep(monitor1 -> proxy.setPropertyLocal(new String[]{wcPath}, property, SVNDepth.EMPTY, 0L, null, new SVNProgressMonitor(this, monitor1, null)), monitor, properties.length);
            ++i;
        }
    }
}

