/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNEntryStatusCallback;
import org.eclipse.team.svn.core.connector.ISVNNotificationCallback;
import org.eclipse.team.svn.core.connector.SVNChangeStatus;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.connector.SVNEntry;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNEntryStatus;
import org.eclipse.team.svn.core.connector.SVNNotification;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.operation.local.IRemoteStatusOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IResourceChange;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class RemoteStatusOperation
extends AbstractWorkingCopyOperation
implements IRemoteStatusOperation,
ISVNNotificationCallback {
    protected SVNChangeStatus[] statuses;
    protected Map<String, SVNRevision.Number> pegRevisions = new HashMap<String, SVNRevision.Number>();

    public RemoteStatusOperation(IResource[] resources) {
        super("Operation_UpdateStatus", SVNMessages.class, resources);
    }

    public RemoteStatusOperation(IResourceProvider provider) {
        super("Operation_UpdateStatus", SVNMessages.class, provider);
    }

    @Override
    public IResource[] getScope() {
        return this.operableData();
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] resources = FileUtility.shrinkChildNodes(this.operableData());
        final HashSet<Path> projectPaths = new HashSet<Path>();
        int i = 0;
        while (i < resources.length && !monitor.isCanceled()) {
            projectPaths.add(new Path(FileUtility.getWorkingCopyPath((IResource)resources[i].getProject())));
            ++i;
        }
        final HashMap result = new HashMap();
        final ArrayList conflicts = new ArrayList();
        ISVNEntryStatusCallback cb = new ISVNEntryStatusCallback(){

            @Override
            public void next(SVNChangeStatus status) {
                IPath projectPath;
                String parent;
                result.put(new Path(status.path), status);
                if (status.hasConflict && status.treeConflicts == null) {
                    conflicts.add(status);
                }
                if ((parent = new File(status.path).getParent()) != null && (projectPath = this.getProjectPath(parent)) != null) {
                    if (status.reposKind != SVNEntry.Kind.DIR) {
                        this.postStatus(parent, status);
                    }
                    this.postStatus(projectPath.toString(), status);
                }
            }

            private void postStatus(String path, SVNChangeStatus baseStatus) {
                Path tPath = new Path(path);
                SVNChangeStatus st = (SVNChangeStatus)result.get(tPath);
                if (st == null || st.reposLastCmtRevision < baseStatus.reposLastCmtRevision) {
                    SVNChangeStatus status = this.makeStatus(path, baseStatus);
                    result.put(tPath, status);
                }
            }

            private SVNChangeStatus makeStatus(String path, SVNChangeStatus status) {
                int deltaSegments = new Path(status.path).segmentCount() - new Path(path).segmentCount();
                return new SVNChangeStatus(path, status.url != null ? SVNUtility.createPathForSVNUrl(status.url).removeLastSegments(deltaSegments).toString() : null, SVNEntry.Kind.DIR, -1L, -1L, 0L, null, SVNEntryStatus.Kind.NORMAL, SVNEntryStatus.Kind.NONE, SVNEntryStatus.Kind.NORMAL, SVNEntryStatus.Kind.MODIFIED, false, false, false, null, null, status.reposLastCmtRevision, status.reposLastCmtDate, SVNEntry.Kind.DIR, status.reposLastCmtAuthor, false, false, null, null);
            }

            private IPath getProjectPath(String path) {
                Path tPath = new Path(path);
                for (IPath projectPath : projectPaths) {
                    if (!projectPath.isPrefixOf((IPath)tPath)) continue;
                    return projectPath;
                }
                return null;
            }
        };
        int i2 = 0;
        while (i2 < resources.length && !monitor.isCanceled()) {
            IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(resources[i2]);
            ISVNConnector proxy = location.acquireSVNProxy();
            SVNUtility.addSVNNotifyListener(proxy, this);
            IResource current = resources[i2];
            ProgressMonitorUtility.setTaskInfo(monitor, this, current.getFullPath().toString());
            conflicts.clear();
            this.protectStep(monitor1 -> proxy.status(FileUtility.getWorkingCopyPath(current), SVNDepth.UNKNOWN, 0x200000040L, null, cb, new SVNProgressMonitor(this, monitor1, null, false)), monitor, resources.length);
            SVNUtility.removeSVNNotifyListener(proxy, this);
            Iterator it = conflicts.iterator();
            while (it.hasNext() && !monitor.isCanceled()) {
                SVNChangeStatus svnChangeStatus = (SVNChangeStatus)it.next();
                this.protectStep(monitor1 -> proxy.getInfo(new SVNEntryRevisionReference(sVNChangeStatus.path), SVNDepth.EMPTY, 0x1000000000L, null, info -> svnChangeStatus.setTreeConflicts(info.treeConflicts), new SVNProgressMonitor(this, monitor1, null, false)), monitor, resources.length);
            }
            location.releaseSVNProxy(proxy);
            ++i2;
        }
        this.statuses = result.values().toArray(new SVNChangeStatus[result.size()]);
    }

    @Override
    public SVNEntryStatus[] getStatuses() {
        return this.statuses;
    }

    @Override
    public void setPegRevision(IResourceChange change) {
        IPath resourcePath = FileUtility.getResourcePath(change.getResource());
        int prefixLength = 0;
        SVNRevision revision = SVNRevision.INVALID_REVISION;
        for (Map.Entry<String, SVNRevision.Number> entry : this.pegRevisions.entrySet()) {
            Path rootPath = new Path(entry.getKey());
            int segments = rootPath.segmentCount();
            if (!rootPath.isPrefixOf(resourcePath) || segments <= prefixLength) continue;
            prefixLength = segments;
            revision = entry.getValue();
        }
        if (revision != SVNRevision.INVALID_REVISION) {
            change.setPegRevision(revision);
        } else if (change.getResource().getType() == 4) {
            IRepositoryResource remote = SVNRemoteStorage.instance().asRepositoryResource(change.getResource());
            change.setPegRevision(remote.getPegRevision());
        }
    }

    @Override
    public void notify(SVNNotification info) {
        if (info.revision != -1L) {
            this.pegRevisions.put(info.path, SVNRevision.fromNumber(info.revision));
        }
    }
}

