/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNMergeStatusCallback;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNEntryReference;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNEntryStatus;
import org.eclipse.team.svn.core.connector.SVNMergeHelper;
import org.eclipse.team.svn.core.connector.SVNMergeStatus;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.local.AbstractMergeSet;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.operation.local.IRemoteStatusOperation;
import org.eclipse.team.svn.core.operation.local.MergeSet1URL;
import org.eclipse.team.svn.core.operation.local.MergeSet2URL;
import org.eclipse.team.svn.core.operation.local.MergeSetReintegrate;
import org.eclipse.team.svn.core.resource.IResourceChange;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class MergeStatusOperation
extends AbstractWorkingCopyOperation
implements IRemoteStatusOperation {
    protected AbstractMergeSet info;
    protected SVNMergeStatus[] retVal;

    public MergeStatusOperation(AbstractMergeSet info, IResource[] resources) {
        super("Operation_MergeStatus", SVNMessages.class, resources == null ? info.to : resources);
        this.info = info;
    }

    @Override
    public IResource[] getScope() {
        return this.info.to;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        ArrayList st = new ArrayList();
        HashSet<IResource> resources = new HashSet<IResource>(Arrays.asList(this.operableData()));
        ISVNMergeStatusCallback cb = status -> {
            boolean bl = st.add(status);
        };
        int i = 0;
        while (i < this.info.to.length && !monitor.isCanceled()) {
            if (resources.contains(this.info.to[i])) {
                ProgressMonitorUtility.setTaskInfo(monitor, this, this.info.to[i].getFullPath().toString());
                int idx = i;
                this.protectStep(monitor1 -> {
                    if (this.info instanceof MergeSet1URL) {
                        this.doMerge1URL(idx, cb, monitor1);
                    } else if (this.info instanceof MergeSet2URL) {
                        this.doMerge2URL(idx, cb, monitor1);
                    } else {
                        this.doMergeReintegrate(idx, cb, monitor1);
                    }
                }, monitor, this.info.to.length);
            }
            ++i;
        }
        this.retVal = st.toArray(new SVNMergeStatus[st.size()]);
        this.info.addStatuses(this.retVal);
    }

    @Override
    public SVNEntryStatus[] getStatuses() {
        return this.retVal;
    }

    @Override
    public void setPegRevision(IResourceChange change) {
    }

    protected void doMerge1URL(int idx, ISVNMergeStatusCallback cb, IProgressMonitor monitor) throws Exception {
        MergeSet1URL info = (MergeSet1URL)this.info;
        SVNEntryRevisionReference mergeRef = SVNUtility.getEntryRevisionReference(info.from[idx]);
        String wcPath = FileUtility.getWorkingCopyPath(info.to[idx]);
        long options = info.ignoreAncestry ? 512L : 0L;
        options |= info.recordOnly ? 2048L : 0L;
        ISVNConnector proxy = info.from[idx].getRepositoryLocation().acquireSVNProxy();
        try {
            SVNMergeHelper helper = new SVNMergeHelper(proxy);
            helper.mergeStatus((SVNEntryReference)mergeRef, info.revisions, wcPath, info.depth, options, cb, (ISVNProgressMonitor)new SVNProgressMonitor(this, monitor, null));
        }
        finally {
            info.from[idx].getRepositoryLocation().releaseSVNProxy(proxy);
        }
    }

    protected void doMerge2URL(int idx, ISVNMergeStatusCallback cb, IProgressMonitor monitor) throws Exception {
        MergeSet2URL info = (MergeSet2URL)this.info;
        SVNEntryRevisionReference startRef = SVNUtility.getEntryRevisionReference(info.fromStart[idx]);
        SVNEntryRevisionReference endRef = SVNUtility.getEntryRevisionReference(info.fromEnd[idx]);
        String wcPath = FileUtility.getWorkingCopyPath(info.to[idx]);
        long options = info.ignoreAncestry ? 516L : 4L;
        options |= info.recordOnly ? 2048L : 0L;
        ISVNConnector proxy = info.fromEnd[idx].getRepositoryLocation().acquireSVNProxy();
        try {
            SVNMergeHelper helper = new SVNMergeHelper(proxy);
            helper.mergeStatus(startRef, endRef, wcPath, info.depth, options, cb, (ISVNProgressMonitor)new SVNProgressMonitor(this, monitor, null));
        }
        finally {
            info.fromEnd[idx].getRepositoryLocation().releaseSVNProxy(proxy);
        }
    }

    protected void doMergeReintegrate(int idx, ISVNMergeStatusCallback cb, IProgressMonitor monitor) throws Exception {
        MergeSetReintegrate info = (MergeSetReintegrate)this.info;
        SVNEntryRevisionReference mergeRef = SVNUtility.getEntryRevisionReference(info.from[idx]);
        String wcPath = FileUtility.getWorkingCopyPath(info.to[idx]);
        ISVNConnector proxy = info.from[idx].getRepositoryLocation().acquireSVNProxy();
        try {
            SVNMergeHelper helper = new SVNMergeHelper(proxy);
            helper.mergeStatus(mergeRef, wcPath, 0L, cb, new SVNProgressMonitor(this, monitor, null));
        }
        finally {
            info.from[idx].getRepositoryLocation().releaseSVNProxy(proxy);
        }
    }
}

