/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNNotificationCallback;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class BranchTagOperation
extends AbstractWorkingCopyOperation {
    protected IRepositoryResource destination;
    protected String message;

    public BranchTagOperation(String operationName, IResource[] resources, IRepositoryResource destination, String message) {
        super("Operation_" + operationName, SVNMessages.class, resources);
        this.destination = destination;
        this.message = message;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        Object[] resources = this.operableData();
        ProgressMonitorUtility.setTaskInfo(monitor, this, FileUtility.getNamesListAsString(resources));
        IRepositoryLocation location = this.destination.getRepositoryLocation();
        ISVNConnector proxy = location.acquireSVNProxy();
        try {
            String destinationUrl = SVNUtility.encodeURL(this.destination.getUrl());
            Object[] objectArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                String wcPath = FileUtility.getWorkingCopyPath((IResource)element);
                ISVNNotificationCallback notify = info -> {
                    if (info.revision != -1L) {
                        String message = BaseMessages.format(SVNMessages.Console_CommittedRevision, new String[]{String.valueOf(info.revision)});
                        this.writeToConsole(1, message);
                    }
                };
                SVNUtility.addSVNNotifyListener(proxy, notify);
                this.protectStep(monitor1 -> {
                    this.writeToConsole(0, "svn copy \"" + wcPath + "\" \"" + destinationUrl + "\" -r " + String.valueOf(SVNRevision.WORKING) + " -m \"" + this.message + "\"" + ISVNConnector.Options.asCommandLine(8L) + FileUtility.getUsernameParam(this.destination.getRepositoryLocation().getUsername()) + "\n");
                    SVNEntryRevisionReference[] src = new SVNEntryRevisionReference[]{new SVNEntryRevisionReference(wcPath, SVNRevision.WORKING, SVNRevision.WORKING)};
                    proxy.copyRemote(src, destinationUrl, this.message, 8L, null, ISVNConnector.NO_EXTERNALS_TO_PIN, new SVNProgressMonitor(this, monitor1, null));
                }, monitor, resources.length);
                SVNUtility.removeSVNNotifyListener(proxy, notify);
                ++n2;
            }
        }
        finally {
            location.releaseSVNProxy(proxy);
        }
    }
}

