/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.file;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.file.AbstractFileOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class CheckoutAsOperation
extends AbstractFileOperation {
    protected IRepositoryResource resource;
    protected SVNDepth depth;
    protected long options;
    protected boolean override;

    public CheckoutAsOperation(File to, IRepositoryResource resource, SVNDepth depth, boolean ignoreExternals, boolean override) {
        this(to, resource, depth, ignoreExternals ? 1L : 0L, override);
    }

    public CheckoutAsOperation(File to, IRepositoryResource resource, SVNDepth depth, long options, boolean override) {
        super("Operation_CheckoutAsFile", SVNMessages.class, new File[]{to});
        this.resource = resource;
        this.depth = depth;
        this.options = options & 3L;
        this.override = override;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        File[] children;
        File to = this.operableData()[0];
        if (this.override && (children = to.listFiles()) != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                FileUtility.deleteRecursive(child, monitor);
                ++n2;
            }
        }
        to.mkdirs();
        IRepositoryLocation location = this.resource.getRepositoryLocation();
        ISVNConnector proxy = location.acquireSVNProxy();
        try {
            String path = to.getAbsolutePath();
            proxy.checkout(SVNUtility.getEntryRevisionReference(this.resource), path, this.depth, this.options, new SVNProgressMonitor(this, monitor, null));
        }
        finally {
            location.releaseSVNProxy(proxy);
        }
    }
}

