/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize;

import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.ui.synchronize.ChangeSetCapability;
import org.eclipse.team.internal.ui.synchronize.IChangeSetProvider;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.synchronize.AbstractSVNSubscriber;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.synchronize.AbstractSynchronizeActionGroup;
import org.eclipse.team.svn.ui.synchronize.SVNChangeSetCapability;
import org.eclipse.team.svn.ui.synchronize.SynchronizeLabelDecorator;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantDescriptor;
import org.eclipse.team.ui.synchronize.ISynchronizeScope;
import org.eclipse.team.ui.synchronize.SubscriberParticipant;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PartInitException;

public abstract class AbstractSVNParticipant
extends SubscriberParticipant
implements IChangeSetProvider {
    public static ImageDescriptor OVR_OBSTRUCTED;
    public static ImageDescriptor OVR_REPLACED_OUT;
    public static ImageDescriptor OVR_REPLACED_IN;
    public static ImageDescriptor OVR_REPLACED_CONF;
    public static ImageDescriptor OVR_PROPCHANGE;
    protected ISynchronizePageConfiguration configuration;
    private ChangeSetCapability capability;

    static {
        SVNTeamUIPlugin instance = SVNTeamUIPlugin.instance();
        OVR_OBSTRUCTED = instance.getImageDescriptor("icons/overlays/obstructed.gif");
        OVR_REPLACED_OUT = instance.getImageDescriptor("icons/overlays/replaced_out.gif");
        OVR_REPLACED_IN = instance.getImageDescriptor("icons/overlays/replaced_in.gif");
        OVR_REPLACED_CONF = instance.getImageDescriptor("icons/overlays/replaced_conf.gif");
        OVR_PROPCHANGE = instance.getImageDescriptor("icons/overlays/prop_changed.png");
    }

    public AbstractSVNParticipant() {
    }

    public AbstractSVNParticipant(ISynchronizeScope scope) {
        super(scope);
        this.setSubscriber((Subscriber)this.getMatchingSubscriber());
    }

    public void init(String secondaryId, IMemento memento) throws PartInitException {
        super.init(secondaryId, memento);
        this.setSubscriber((Subscriber)this.getMatchingSubscriber());
    }

    public ISynchronizePageConfiguration getConfiguration() {
        return this.configuration;
    }

    public synchronized ChangeSetCapability getChangeSetCapability() {
        if (this.capability == null) {
            this.capability = new SVNChangeSetCapability();
        }
        return this.capability;
    }

    protected ISynchronizeParticipantDescriptor getDescriptor() {
        return TeamUI.getSynchronizeManager().getParticipantDescriptor(this.getParticipantId());
    }

    protected boolean isViewerContributionsSupported() {
        return true;
    }

    protected void initializeConfiguration(ISynchronizePageConfiguration configuration) {
        super.initializeConfiguration(configuration);
        this.configuration = configuration;
        Collection<AbstractSynchronizeActionGroup> actionGroups = this.getActionGroups();
        for (AbstractSynchronizeActionGroup actionGroup : actionGroups) {
            actionGroup.configureMenuGroups(configuration);
        }
        for (AbstractSynchronizeActionGroup actionGroup : actionGroups) {
            configuration.addActionContribution((SynchronizePageActionGroup)actionGroup);
        }
        configuration.addLabelDecorator(this.createLabelDecorator(configuration));
        if (this.isSetModes()) {
            configuration.setSupportedModes(this.getSupportedModes());
            configuration.setMode(this.getDefaultMode());
        }
    }

    protected boolean isSetModes() {
        return true;
    }

    protected ILabelDecorator createLabelDecorator(ISynchronizePageConfiguration configuration) {
        return new SynchronizeLabelDecorator(configuration);
    }

    public abstract AbstractSVNSubscriber getMatchingSubscriber();

    protected abstract String getParticipantId();

    protected abstract Collection<AbstractSynchronizeActionGroup> getActionGroups();

    protected abstract int getSupportedModes();

    protected abstract int getDefaultMode();

    protected void setSubscriber(Subscriber subscriber) {
        super.setSubscriber(subscriber);
        try {
            ISynchronizeParticipantDescriptor descriptor = this.getDescriptor();
            this.setInitializationData(descriptor);
        }
        catch (CoreException e) {
            LoggedOperation.reportError((String)((Object)((Object)this)).getClass().getName(), (Throwable)e);
        }
        if (this.getSecondaryId() == null) {
            this.setSecondaryId(Long.toString(System.currentTimeMillis()));
        }
    }
}

