/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.icteam.common.clientserver.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.xml.Jaxp;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.icteam.common.clientserver.Activator;
import org.eclipse.osee.icteam.common.clientserver.util.CommentType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CommentItem {
    private Date date;
    private final String state;
    private String msg;
    private String user;
    private CommentType type = CommentType.Other;
    protected static final String ITEM_TAG = "Item";
    private static final String Comment_Tag = "CommentTag";

    public CommentItem(String type, String state, String date1, String user, String msg) {
        Long l = Long.valueOf(date1);
        this.date = new Date(l);
        this.state = state;
        this.msg = msg;
        this.user = user;
        try {
            this.type = CommentType.getType(type);
        }
        catch (OseeArgumentException e) {
            e.printStackTrace();
        }
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String toString() {
        return String.format("Note: %s from %s%s on %s - %s", this.user, this.toStringState(), DateUtil.getMMDDYYHHMM((Date)this.date), this.msg);
    }

    private String toStringState() {
        return this.state.isEmpty() ? "" : " for \"" + this.state + "\"";
    }

    public String getUser() {
        return this.user;
    }

    public CommentType getType() {
        return this.type;
    }

    public void setType(CommentType type) {
        this.type = type;
    }

    public String toHTML() {
        return this.toString().replaceFirst("^Note: ", "<b>Note:</b>");
    }

    public String getState() {
        return this.state;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public static List<CommentItem> fromXml(String xml, String hrid) {
        ArrayList<CommentItem> logItems = new ArrayList<CommentItem>();
        try {
            NodeList nodes = Jaxp.readXmlDocument((String)xml).getElementsByTagName(ITEM_TAG);
            int i = 0;
            while (i < nodes.getLength()) {
                Element element = (Element)nodes.item(i);
                CommentItem item = new CommentItem(element.getAttribute("type"), element.getAttribute("state"), element.getAttribute("date"), element.getAttribute("userId"), element.getAttribute("msg"));
                logItems.add(item);
                ++i;
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return logItems;
    }

    public static String toXml(List<CommentItem> items) {
        try {
            Document doc = Jaxp.newDocumentNamespaceAware();
            Element rootElement = doc.createElement(Comment_Tag);
            doc.appendChild(rootElement);
            for (CommentItem item : items) {
                Element element = doc.createElement(ITEM_TAG);
                element.setAttribute("type", item.getType().name());
                element.setAttribute("state", item.getState());
                element.setAttribute("date", String.valueOf(item.getDate().getTime()));
                element.setAttribute("userId", item.getUser());
                element.setAttribute("msg", item.getMsg());
                rootElement.appendChild(element);
            }
            return Jaxp.getDocumentXml((Document)doc);
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)"Can't create ats note document", (Throwable)ex);
            return null;
        }
    }
}

