/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.indexer;

import java.util.concurrent.Future;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.executor.ExecutorAdmin;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.SystemProperties;
import org.eclipse.osee.orcs.core.ds.IndexerData;
import org.eclipse.osee.orcs.core.ds.QueryEngineIndexer;
import org.eclipse.osee.orcs.core.internal.HasStatistics;
import org.eclipse.osee.orcs.core.internal.indexer.QueryIndexerImpl;
import org.eclipse.osee.orcs.core.internal.indexer.statistics.IndexerStatisticsCollectorImpl;
import org.eclipse.osee.orcs.core.internal.indexer.statistics.IndexerStatisticsImpl;
import org.eclipse.osee.orcs.search.IndexerCollector;
import org.eclipse.osee.orcs.search.QueryIndexer;
import org.eclipse.osee.orcs.statistics.IndexerStatistics;

public class IndexerModule
implements HasStatistics<IndexerStatistics> {
    private final IndexerStatisticsImpl statistics = new IndexerStatisticsImpl();
    private final Log logger;
    private final SystemProperties properties;
    private final ExecutorAdmin executorAdmin;
    private final QueryEngineIndexer queryIndexer;
    private final IndexerCollector systemCollector;
    private Future<Integer> task;

    public IndexerModule(Log logger, SystemProperties properties, ExecutorAdmin executorAdmin, QueryEngineIndexer queryIndexer) {
        this.logger = logger;
        this.properties = properties;
        this.executorAdmin = executorAdmin;
        this.queryIndexer = queryIndexer;
        this.systemCollector = new IndexerStatisticsCollectorImpl(this.statistics);
    }

    public void start(OrcsSession systemSession, OrcsTokenService tokenService) {
        this.queryIndexer.addCollector(this.systemCollector);
        try {
            if (this.properties.isBoolean("osee.check.tag.queue.on.startup")) {
                this.task = this.executorAdmin.submit("Attribute Indexer", this.queryIndexer.indexAllFromQueue(systemSession, tokenService, new IndexerCollector[0]));
            } else {
                this.logger.info("Indexer was not executed on Server Startup.", new Object[0]);
            }
        }
        catch (Exception exception) {
            this.logger.info("Indexer was not executed on Server Startup.", new Object[0]);
        }
    }

    public void stop() {
        this.queryIndexer.removeCollector(this.systemCollector);
        if (this.task != null) {
            this.task.cancel(true);
            this.task = null;
        }
    }

    @Override
    public IndexerStatistics getStatistics(OrcsSession session) {
        try {
            IndexerData indexerData = (IndexerData)this.queryIndexer.getIndexerData(session).call();
            this.statistics.setIndexerData(indexerData);
        }
        catch (Exception ex) {
            this.logger.warn((Throwable)ex, "Error fetching indexer data - stats are unreliable", new Object[0]);
        }
        return this.statistics;
    }

    @Override
    public void clearStatistics(OrcsSession session) {
        this.statistics.clear();
    }

    public QueryIndexer createQueryIndexer(OrcsSession session, OrcsTokenService tokenService) {
        return new QueryIndexerImpl(session, this.queryIndexer, tokenService);
    }
}

