/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.operations;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.orcs.OrcsApi;

public class ValidateBranchOperation {
    private final String FIND_CHILDREN_WITH_DUPLICATE_DEF_HIER_PARENTS = "select the_count, b_art_id from ( SELECT count(*) the_count , B_ART_ID FROM OSEE_RELATION_LINK lin, OSEE_TXS txs WHERE txs.BRANCH_ID = ? AND lin.REL_LINK_TYPE_ID = 2305843009213694292 AND txs.GAMMA_ID = lin.GAMMA_ID AND txs.TX_CURRENT = 1 GROUP BY B_ART_ID ) count_alias where the_count > 1";
    private final BranchId branch;
    private final JdbcClient jdbcClient;
    private final XResultData results;
    private final OrcsApi orcsApi;

    public ValidateBranchOperation(JdbcClient jdbcClient, BranchId branch, XResultData results, OrcsApi orcsApi) {
        this.jdbcClient = jdbcClient;
        this.branch = branch;
        this.results = results;
        this.orcsApi = orcsApi;
    }

    public ValidateBranchOperation(JdbcClient jdbcClient, BranchId branch, OrcsApi orcsApi) {
        this(jdbcClient, branch, new XResultData(false), orcsApi);
    }

    public XResultData getChildrenWithMultipleParents(ArtifactTypeToken artType) {
        LinkedList<Long> artIds = new LinkedList<Long>();
        this.jdbcClient.runQuery(stmt -> {
            boolean bl = artIds.add(stmt.getLong("b_art_id"));
        }, "select the_count, b_art_id from ( SELECT count(*) the_count , B_ART_ID FROM OSEE_RELATION_LINK lin, OSEE_TXS txs WHERE txs.BRANCH_ID = ? AND lin.REL_LINK_TYPE_ID = 2305843009213694292 AND txs.GAMMA_ID = lin.GAMMA_ID AND txs.TX_CURRENT = 1 GROUP BY B_ART_ID ) count_alias where the_count > 1", new Object[]{this.branch});
        LinkedList<Long> returnArtIds = new LinkedList<Long>();
        if (artType.isValid()) {
            returnArtIds.addAll(this.filterByArtifactTypeInherited(artIds, artType));
        } else {
            returnArtIds.addAll(artIds);
        }
        if (!artIds.isEmpty()) {
            this.results.errorf("Children have duplicate default hierarchy parents [%s].", new Object[]{Collections.toString((String)",", returnArtIds)});
            for (Long id : returnArtIds) {
                this.results.getIds().add(id.toString());
            }
        }
        return this.results;
    }

    public XResultData runAll(ArtifactTypeToken artType) {
        this.getChildrenWithMultipleParents(artType);
        this.getOrphans(artType);
        return this.results;
    }

    public XResultData getOrphans(ArtifactTypeToken artType) {
        LinkedList<Long> resultIds = new LinkedList<Long>();
        for (ArtifactId art : this.orcsApi.getQueryFactory().fromBranch(this.branch).andRelationNotExists(CoreRelationTypes.DefaultHierarchical_Child).andIsOfType(new ArtifactTypeToken[]{artType}).asArtifactIds()) {
            resultIds.add(art.getId());
        }
        return this.results;
    }

    private List<Long> filterByArtifactTypeInherited(List<Long> artIds, ArtifactTypeToken artType) {
        LinkedList<Long> resultIds = new LinkedList<Long>();
        for (ArtifactId art : this.orcsApi.getQueryFactory().fromBranch(this.branch).andIdsL(artIds).andIsOfType(new ArtifactTypeToken[]{artType}).asArtifactIds()) {
            resultIds.add(art.getId());
        }
        return resultIds;
    }
}

