/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.security.oauth2;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenValidation;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.utils.AuthorizationUtils;
import org.apache.cxf.security.LoginSecurityContext;
import org.apache.cxf.security.SecurityContext;
import org.eclipse.osee.account.admin.OseePrincipal;
import org.eclipse.osee.framework.jdk.core.type.BaseIdentity;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jaxrs.server.internal.JaxRsUtils;
import org.eclipse.osee.jaxrs.server.internal.security.util.CustomSecurityContextImpl;

public final class OAuthUtil {
    private static final String SUBJECT_USERNAME = "username";
    private static final String SUBJECT_DISPLAY_NAME = "display.name";
    private static final String SUBJECT_EMAIL = "email";
    private static final String SUBJECT_IS_ACTIVE = "is.active";
    private static final String SUBJECT_IS_AUTHENTICATED = "is.authenticated";

    private OAuthUtil() {
    }

    public static String asExpirationValue(long expiresIn) {
        String msg = "minutes";
        long value = TimeUnit.MINUTES.convert(expiresIn, TimeUnit.MILLISECONDS);
        if (value <= 1L) {
            value = TimeUnit.SECONDS.convert(expiresIn, TimeUnit.MILLISECONDS);
            msg = "seconds";
        }
        return String.format("%s %s", value, msg);
    }

    public static String[] decodeCredentials(String header) {
        String substring = header.substring("Basic ".length());
        return AuthorizationUtils.getBasicAuthParts((String)substring);
    }

    public static String encodeCredentials(String username, String password) {
        String encoded;
        String credentials = String.format("%s:%s", username, password);
        try {
            encoded = Base64Utility.encode((byte[])credentials.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new OAuthServiceException("Error encoded credentials");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Basic");
        builder.append(" ");
        builder.append(encoded);
        return builder.toString();
    }

    public static URI computeRedirectUri(URI redirectURI, boolean ignoreBasePath, Message m, ContainerRequestContext context) {
        URI finalRedirectURI = null;
        if (redirectURI != null) {
            if (!redirectURI.isAbsolute()) {
                String server;
                int index;
                String endpointAddress = HttpUtils.getEndpointAddress((Message)m);
                Object basePathProperty = m.get((Object)Message.BASE_PATH);
                if (ignoreBasePath && basePathProperty != null && !"/".equals(basePathProperty) && (index = endpointAddress.lastIndexOf(basePathProperty.toString())) != -1) {
                    endpointAddress = endpointAddress.substring(0, index);
                }
                UriInfo uriInfo = context.getUriInfo();
                URI requestUrl = uriInfo.getRequestUri();
                String scheme = requestUrl.getScheme();
                String forwardedServer = OAuthUtil.getForwarderServer();
                if (Strings.isValid((String)forwardedServer)) {
                    server = forwardedServer;
                } else {
                    int port = requestUrl.getPort();
                    server = String.format("%s:%s", requestUrl.getHost(), port);
                }
                URI requestUrlWithServer = UriBuilder.fromPath((String)server).path(requestUrl.getPath()).replaceQuery(requestUrl.getRawQuery()).scheme(scheme).build(new Object[0]);
                String continueURL = requestUrlWithServer.toASCIIString();
                finalRedirectURI = UriBuilder.fromPath((String)server).scheme(scheme).path(redirectURI.toString()).queryParam("continueTo", new Object[]{continueURL}).build(new Object[0]);
            } else {
                finalRedirectURI = redirectURI;
            }
        }
        return finalRedirectURI;
    }

    public static Response newAuthorizationRequiredResponse(Exception ex, URI redirectURI, boolean ignoreBasePath, String realmName, Message m, ContainerRequestContext context) {
        HttpHeadersImpl headers = new HttpHeadersImpl(m);
        if (redirectURI != null && JaxRsUtils.isHtmlSupported(headers.getAcceptableMediaTypes())) {
            URI finalRedirectURI = OAuthUtil.computeRedirectUri(redirectURI, ignoreBasePath, m, context);
            Response.ResponseBuilder toReturn = Response.temporaryRedirect((URI)finalRedirectURI);
            if (ex != null) {
                toReturn.entity((Object)"Incorrect Username/Password");
            }
            return toReturn.build();
        }
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED);
        StringBuilder sb = new StringBuilder();
        List authHeader = headers.getRequestHeader("Authorization");
        if (authHeader != null && authHeader.size() > 0) {
            String[] authValues;
            String firstHeader = (String)authHeader.get(0);
            String[] stringArray = authValues = Strings.isValid((String)firstHeader) ? firstHeader.split(" ") : null;
            if (authValues != null && authValues.length > 0) {
                sb.append(authValues[0]);
            }
        } else {
            sb.append("Basic");
        }
        if (realmName != null) {
            sb.append(" realm=\"").append(realmName).append('\"');
        }
        builder.header("WWW-Authenticate", (Object)sb.toString());
        return builder.build();
    }

    public static String getForwarderServer() {
        Message currentMessage = PhaseInterceptorChain.getCurrentMessage();
        TreeMap headers = (TreeMap)currentMessage.get((Object)"org.apache.cxf.message.Message.PROTOCOL_HEADERS");
        List forwarderServers = (List)headers.get("X-Forwarded-Server");
        if (forwarderServers != null) {
            return (String)forwarderServers.get(0);
        }
        return "";
    }

    public static SecurityContext getSecurityContext(AccessTokenValidation accessTokenV, boolean useUserSubject) {
        UserSubject resourceOwnerSubject = accessTokenV.getTokenSubject();
        UserSubject clientSubject = accessTokenV.getClientSubject();
        UserSubject subject = resourceOwnerSubject != null || useUserSubject ? resourceOwnerSubject : clientSubject;
        return OAuthUtil.newSecurityContext(subject);
    }

    public static SecurityContext newSecurityContext(UserSubject subject) {
        OseePrincipal principal = OAuthUtil.newOseePrincipal(subject);
        return OAuthUtil.newSecurityContext(principal);
    }

    public static SecurityContext newSecurityContext(OseePrincipal principal) {
        return new CustomSecurityContextImpl(principal);
    }

    public static UserSubject newUserSubject(OseePrincipal subject) {
        ArrayList<String> roles = new ArrayList<String>();
        for (String role : subject.getRoles()) {
            roles.add(role);
        }
        UserSubject data = new UserSubject();
        data.setId(String.valueOf(subject.getGuid()));
        String userName = subject.getUserName();
        if (Strings.isValid((String)userName)) {
            data.setLogin(subject.getUserName());
        } else {
            data.setLogin(subject.getLogin());
        }
        data.setRoles(roles);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(SUBJECT_USERNAME, subject.getUserName());
        String displayName = subject.getDisplayName();
        if (displayName.contains(",")) {
            String[] names = displayName.split(",");
            displayName = String.format("%s %s", names[1].trim(), names[0].trim());
        }
        properties.put(SUBJECT_DISPLAY_NAME, displayName);
        properties.put(SUBJECT_EMAIL, subject.getEmailAddress());
        properties.put(SUBJECT_IS_ACTIVE, Boolean.toString(subject.isActive()));
        properties.put(SUBJECT_IS_AUTHENTICATED, Boolean.toString(subject.isAuthenticated()));
        data.setProperties(properties);
        return data;
    }

    public static OseePrincipal newOseePrincipal(UserSubject subject) {
        Long id = OAuthUtil.getUserSubjectUuid(subject);
        LinkedHashSet<String> roles = new LinkedHashSet<String>();
        List sRoles = subject.getRoles();
        if (sRoles != null) {
            roles.addAll(sRoles);
        }
        return new UserSubjectWrapper(id, subject, roles);
    }

    public static Long getUserSubjectUuid(UserSubject subject) {
        String value = subject.getId();
        return Strings.isNumeric((String)value) ? Long.parseLong(value) : -1L;
    }

    public static String getDisplayName(UserSubject subject) {
        return OAuthUtil.getProperty(subject.getProperties(), SUBJECT_DISPLAY_NAME, subject.getLogin());
    }

    private static String getProperty(Map<String, String> props, String key, String defaultValue) {
        String toReturn = props.get(key);
        if (toReturn == null) {
            toReturn = defaultValue;
        }
        return toReturn;
    }

    public static UserSubject newSubject(SecurityContext securityContext) {
        UserSubject subject;
        Principal principal = securityContext.getUserPrincipal();
        if (principal instanceof OseePrincipal) {
            OseePrincipal oseePrincipal = (OseePrincipal)principal;
            subject = OAuthUtil.newUserSubject(oseePrincipal);
        } else {
            String name = principal != null ? principal.getName() : "UNKNOWN";
            List roleNames = Collections.emptyList();
            if (securityContext instanceof LoginSecurityContext) {
                roleNames = new ArrayList();
                Set roles = ((LoginSecurityContext)securityContext).getUserRoles();
                for (Principal p : roles) {
                    roleNames.add(p.getName());
                }
            }
            subject = new UserSubject(name, roleNames);
        }
        return subject;
    }

    public static void saveSecurityContext(MessageContext mc, SecurityContext securityContext) {
        if (securityContext != null) {
            mc.put(SecurityContext.class, (Object)securityContext);
            mc.put((Object)SecurityContext.class.getName(), (Object)securityContext);
        }
    }

    private static final class UserSubjectWrapper
    extends BaseIdentity<Long>
    implements OseePrincipal {
        private final UserSubject subject;
        private final Set<String> roles;

        public UserSubjectWrapper(Long id, UserSubject subject, Set<String> roles) {
            super((Object)id);
            this.subject = subject;
            this.roles = roles;
        }

        public String getName() {
            return this.getDisplayName();
        }

        public String getLogin() {
            return this.subject.getLogin();
        }

        public Set<String> getRoles() {
            return this.roles;
        }

        public String getDisplayName() {
            return this.get(OAuthUtil.SUBJECT_DISPLAY_NAME, Strings.emptyString());
        }

        public String getUserName() {
            return this.get(OAuthUtil.SUBJECT_USERNAME, Strings.emptyString());
        }

        public String getEmailAddress() {
            return this.get(OAuthUtil.SUBJECT_EMAIL, Strings.emptyString());
        }

        public boolean isActive() {
            return Boolean.valueOf(this.get(OAuthUtil.SUBJECT_IS_ACTIVE, Strings.emptyString()));
        }

        public boolean isAuthenticated() {
            return Boolean.valueOf(this.get(OAuthUtil.SUBJECT_IS_AUTHENTICATED, Strings.emptyString()));
        }

        public Map<String, String> getProperties() {
            return this.subject.getProperties();
        }

        private String get(String key, String defaultValue) {
            return OAuthUtil.getProperty(this.getProperties(), key, defaultValue);
        }
    }
}

