/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.sql.join;

import java.util.concurrent.TimeUnit;
import org.eclipse.osee.framework.core.executor.ExecutorAdmin;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.db.internal.sql.join.CharJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.ExportImportJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.Id4JoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.IdJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.JoinCleanerCallable;
import org.eclipse.osee.orcs.db.internal.sql.join.TagQueueJoinQuery;

public class SqlJoinFactory {
    public static final String JOIN_CLEANER__EXECUTOR_ID = "join.cleaner.executor.id";
    private static final long DEFAULT_JOIN_CLEANER__PERIOD_MINUTES = 60L;
    private Log logger;
    private JdbcClient jdbcClient;
    private ExecutorAdmin executorAdmin;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setJdbcService(JdbcService jdbcService) {
        this.jdbcClient = jdbcService.getClient();
    }

    public void setExecutorAdmin(ExecutorAdmin executorAdmin) {
        this.executorAdmin = executorAdmin;
    }

    public void start() throws Exception {
        JoinCleanerCallable runnable = new JoinCleanerCallable(this.logger, this.jdbcClient);
        this.executorAdmin.scheduleAtFixedRate(JOIN_CLEANER__EXECUTOR_ID, (Runnable)runnable, 60L, 60L, TimeUnit.MINUTES);
    }

    public void stop() throws Exception {
        if (this.executorAdmin != null) {
            this.executorAdmin.shutdown(JOIN_CLEANER__EXECUTOR_ID);
        }
    }

    public IdJoinQuery createIdJoinQuery() {
        return this.createIdJoinQuery(null);
    }

    public IdJoinQuery createIdJoinQuery(JdbcConnection connection) {
        return new IdJoinQuery(this.jdbcClient, connection);
    }

    public Id4JoinQuery createId4JoinQuery() {
        return this.createId4JoinQuery(null);
    }

    public Id4JoinQuery createId4JoinQuery(JdbcConnection connection) {
        return new Id4JoinQuery(this.jdbcClient, connection);
    }

    public TagQueueJoinQuery createTagQueueJoinQuery() {
        return this.createTagQueueJoinQuery(null);
    }

    public TagQueueJoinQuery createTagQueueJoinQuery(JdbcConnection connection) {
        return new TagQueueJoinQuery(this.jdbcClient, connection);
    }

    public ExportImportJoinQuery createExportImportJoinQuery() {
        return this.createExportImportJoinQuery(null);
    }

    public ExportImportJoinQuery createExportImportJoinQuery(JdbcConnection connection) {
        return new ExportImportJoinQuery(this.jdbcClient, connection);
    }

    public CharJoinQuery createCharJoinQuery() {
        return this.createCharJoinQuery(null);
    }

    public CharJoinQuery createCharJoinQuery(JdbcConnection connection) {
        return new CharJoinQuery(this.jdbcClient, connection);
    }
}

