/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.tagger;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.type.MatchLocation;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.db.internal.search.tagger.AbstractTagger;
import org.eclipse.osee.orcs.db.internal.search.tagger.StreamMatcher;
import org.eclipse.osee.orcs.db.internal.search.tagger.TagCollector;
import org.eclipse.osee.orcs.db.internal.search.tagger.TagProcessor;

public class TextStreamTagger
extends AbstractTagger {
    public TextStreamTagger(TagProcessor tagProcessor, StreamMatcher matcher) {
        super(tagProcessor, matcher);
    }

    @Override
    public void tagIt(InputStream provider, TagCollector collector) throws Exception {
        InputStream inputStream = null;
        try {
            inputStream = provider;
            this.getTagProcessor().collectFromInputStream(inputStream, collector);
        }
        finally {
            Lib.close((AutoCloseable)inputStream);
        }
    }

    @Override
    public List<MatchLocation> find(InputStream provider, String toSearch, boolean matchAllLocations, QueryOption ... options) throws Exception {
        List<MatchLocation> toReturn;
        if (Strings.isValid((String)toSearch)) {
            InputStream inputStream = null;
            try {
                inputStream = provider;
                toReturn = this.getMatcher().findInStream(inputStream, toSearch, matchAllLocations, options);
            }
            finally {
                Lib.close((AutoCloseable)inputStream);
            }
        } else {
            toReturn = Collections.emptyList();
        }
        return toReturn;
    }
}

