/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import java.util.List;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.jdbc.ObjectType;
import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaRelatedTo;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.join.IdJoinQuery;

public class RelatedToSqlHandler
extends SqlHandler<CriteriaRelatedTo> {
    private CriteriaRelatedTo criteria;
    private String jIdAlias;
    private String relAlias;
    private String txsAlias;
    private String cteAlias;

    @Override
    public void writeCommonTableExpression(AbstractSqlWriter writer) {
        if (OptionsUtil.isHistorical((Options)writer.getOptions())) {
            List<String> aliases;
            this.cteAlias = writer.startCommonTableExpression("relTo");
            writer.write("SELECT max(txs.transaction_id) as transaction_id, rel.a_art_id as art_id\n");
            writer.write(" FROM osee_txs txs, osee_relation_link rel");
            if (this.criteria.hasMultipleIds()) {
                writer.write(", ");
                writer.write(OseeDb.OSEE_JOIN_ID_TABLE.getName());
                writer.write(" ");
                writer.write(this.jIdAlias);
            }
            if (!(aliases = writer.getAliases(OseeDb.ARTIFACT_TABLE)).isEmpty()) {
                int aSize = aliases.size();
                int index = 0;
                while (index < aSize) {
                    String artAlias = aliases.get(index);
                    writer.write(", ");
                    writer.write(OseeDb.ARTIFACT_TABLE.getName());
                    writer.write(" ");
                    writer.write(artAlias);
                    ++index;
                }
            }
            writer.write("\n WHERE  txs.gamma_id = rel.gamma_id AND \n");
            this.writePredicate(writer, "txs", "rel");
            writer.write(" AND ");
            writer.writeTxBranchFilter("txs");
            writer.write("\n GROUP BY rel.a_art_id\n");
        }
    }

    @Override
    public void setData(CriteriaRelatedTo criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        if (this.cteAlias != null) {
            writer.addTable(this.cteAlias);
        }
        if (this.criteria.hasMultipleIds()) {
            this.jIdAlias = writer.addTable(OseeDb.OSEE_JOIN_ID_TABLE);
        }
        this.relAlias = writer.addTable(OseeDb.RELATION_TABLE);
        this.txsAlias = writer.addTable(OseeDb.TXS_TABLE, ObjectType.RELATION);
    }

    private void writePredicate(AbstractSqlWriter writer, String txsAliasName, String relAliasName) {
        String aOrbArtId;
        RelationTypeSide typeSide = (RelationTypeSide)this.criteria.getType();
        writer.write(relAliasName);
        writer.write(".rel_link_type_id = ?");
        writer.addParameter(typeSide.getGuid());
        writer.write(" AND ");
        String string = aOrbArtId = typeSide.getSide().isSideA() ? ".a_art_id" : ".b_art_id";
        if (this.criteria.hasMultipleIds()) {
            IdJoinQuery joinQuery = writer.writeJoin(this.criteria.getIds());
            writer.write(relAliasName);
            writer.write(aOrbArtId);
            writer.write(" = ");
            writer.write(this.jIdAlias);
            writer.write(".id AND ");
            writer.write(this.jIdAlias);
            writer.write(".query_id = ?");
            writer.addParameter(joinQuery.getQueryId());
        } else {
            writer.write(relAliasName);
            writer.write(aOrbArtId);
            writer.write(" = ?");
            writer.addParameter(this.criteria.getId());
        }
        List<String> aliases = writer.getAliases(OseeDb.ARTIFACT_TABLE);
        if (!aliases.isEmpty()) {
            writer.write("\n AND \n");
            String oppositeAOrBartId = typeSide.getSide().isSideA() ? ".b_art_id" : ".a_art_id";
            int aSize = aliases.size();
            int index = 0;
            while (index < aSize) {
                String artAlias = aliases.get(index);
                writer.write(relAliasName);
                writer.write(oppositeAOrBartId);
                writer.write(" = ");
                writer.write(artAlias);
                writer.write(".art_id");
                if (index + 1 < aSize) {
                    writer.write("\n AND \n");
                }
                ++index;
            }
        }
        writer.write("\n AND \n");
        writer.write(relAliasName);
        writer.write(".gamma_id = ");
        writer.write(txsAliasName);
        writer.write(".gamma_id");
    }

    @Override
    public void addPredicates(AbstractSqlWriter writer) {
        this.writePredicate(writer, this.txsAlias, this.relAlias);
        if (this.cteAlias != null) {
            writer.writeAndLn();
            writer.write(this.txsAlias);
            writer.write(".transaction_id = ");
            writer.write(this.cteAlias);
            writer.write(".transaction_id");
        }
        writer.writeAndLn();
        boolean includeDeletedRelations = OptionsUtil.areDeletedRelationsIncluded((Options)writer.getOptions());
        writer.writeTxBranchFilter(this.txsAlias, includeDeletedRelations);
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.RELATED_TO_ART_IDS.ordinal();
    }
}

