/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaArtifactTxComment;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;

public class ArtifactTxCommentSqlHandler
extends SqlHandler<CriteriaArtifactTxComment> {
    private CriteriaArtifactTxComment criteria;
    private String txdAlias;
    private String txsAttAlias;
    private String attAlias;
    private String tuple2Alias;
    private String artAlias;

    @Override
    public void setData(CriteriaArtifactTxComment criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        this.txdAlias = writer.addTable(OseeDb.TX_DETAILS_TABLE);
        this.txsAttAlias = writer.addTable(OseeDb.TXS_TABLE);
        this.attAlias = writer.addTable(OseeDb.ATTRIBUTE_TABLE);
        this.tuple2Alias = writer.addTable(OseeDb.TUPLE2);
        this.artAlias = writer.getMainTableAlias(OseeDb.ARTIFACT_TABLE);
    }

    @Override
    public void addPredicates(AbstractSqlWriter writer) {
        writer.writePatternMatch(this.txdAlias, "osee_comment", this.criteria.getCommentPattern());
        writer.writeBranchFilter(this.txdAlias);
        writer.writeAnd();
        writer.writeEqualsAnd(this.txdAlias, this.txsAttAlias, "transaction_id");
        writer.writeEqualsAnd(this.txdAlias, this.txsAttAlias, "branch_id");
        writer.writeEqualsAnd(this.txsAttAlias, this.attAlias, "gamma_id");
        writer.writeEqualsAnd(this.attAlias, "attr_type_id", this.tuple2Alias, "e2");
        writer.writeEqualsParameterAnd(this.tuple2Alias, "e1", this.criteria.getTypeJoin());
        writer.writeEqualsParameterAnd(this.tuple2Alias, "tuple_type", this.criteria.getTypeJoin().getTupleType());
        writer.writeEquals(this.attAlias, this.artAlias, "art_id");
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.LAST.ordinal();
    }
}

