/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.executor.HasCancellation;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.DataLoader;
import org.eclipse.osee.orcs.core.ds.DataLoaderFactory;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.QueryContext;
import org.eclipse.osee.orcs.db.internal.loader.DataLoaderImpl;
import org.eclipse.osee.orcs.db.internal.loader.SqlObjectLoader;
import org.eclipse.osee.orcs.db.internal.loader.executors.AbstractLoadExecutor;
import org.eclipse.osee.orcs.db.internal.loader.executors.ArtifactQueryContextLoadExecutor;
import org.eclipse.osee.orcs.db.internal.loader.executors.QueryContextLoadExecutor;
import org.eclipse.osee.orcs.db.internal.search.QuerySqlContext;
import org.eclipse.osee.orcs.db.internal.search.engines.ArtifactQuerySqlContext;
import org.eclipse.osee.orcs.db.internal.sql.join.AbstractJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public class DataLoaderFactoryImpl
implements DataLoaderFactory {
    private final Log logger;
    private final JdbcClient jdbcClient;
    private final SqlObjectLoader loader;
    private final SqlJoinFactory joinFactory;

    public DataLoaderFactoryImpl(Log logger, JdbcClient jdbcClient, SqlObjectLoader loader, SqlJoinFactory joinFactory) {
        this.logger = logger;
        this.jdbcClient = jdbcClient;
        this.loader = loader;
        this.joinFactory = joinFactory;
    }

    /*
     * Unable to fully structure code
     */
    public int getCount(HasCancellation cancellation, QueryContext queryContext) {
        context = this.adapt(QuerySqlContext.class, queryContext);
        count = -1;
        startTime = 0L;
        if (this.logger.isTraceEnabled()) {
            startTime = System.currentTimeMillis();
            this.logger.trace("%s Count - queryContext[%s]", new Object[]{this.getClass().getSimpleName(), queryContext});
        }
        try {
            for (AbstractJoinQuery join : context.getJoins()) {
                join.store();
            }
            if (cancellation != null) {
                cancellation.checkForCancelled();
            }
            count = (Integer)this.jdbcClient.fetch((Object)-1, context.getSql(), context.getParameters().toArray());
        }
        finally {
            ** for (join : context.getJoins())
        }
lbl-1000:
        // 1 sources

        {
            try {
                join.close();
            }
            catch (Exception v0) {}
            continue;
        }
lbl22:
        // 1 sources

        if (this.logger.isTraceEnabled()) {
            this.logger.trace("%s Count [%s] - count[%s] queryContext[%s]", new Object[]{this.getClass().getSimpleName(), Lib.getElapseString((long)startTime), count, queryContext});
        }
        return count;
    }

    public DataLoader newDataLoader(QueryContext queryContext) {
        AbstractLoadExecutor executor;
        QuerySqlContext sqlQueryContext;
        if (queryContext instanceof ArtifactQuerySqlContext) {
            sqlQueryContext = this.adapt(ArtifactQuerySqlContext.class, queryContext);
            executor = new ArtifactQueryContextLoadExecutor(this.loader, this.jdbcClient, this.joinFactory, (ArtifactQuerySqlContext)sqlQueryContext);
        } else {
            sqlQueryContext = this.adapt(QuerySqlContext.class, queryContext);
            executor = new QueryContextLoadExecutor(this.loader, this.jdbcClient, sqlQueryContext);
        }
        Options options = OptionsUtil.createOptions();
        return new DataLoaderImpl(this.logger, executor, options, null, null, this.loader, this.joinFactory);
    }

    public DataLoader newDataLoader(OrcsSession session, BranchId branch, Collection<ArtifactId> ids) {
        ArrayList<Integer> intIds = new ArrayList<Integer>();
        for (ArtifactId id : ids) {
            intIds.add(id.getId().intValue());
        }
        return this.newDataLoaderFromIds(session, branch, intIds);
    }

    public DataLoader newDataLoaderFromIds(OrcsSession session, BranchId branch, Collection<Integer> ids) {
        Conditions.checkNotNull((Object)branch, (String)"branch");
        Options options = OptionsUtil.createOptions();
        return new DataLoaderImpl(this.logger, ids, options, session, branch, this.loader, this.joinFactory);
    }

    public DataLoader newDataLoaderFromGuids(OrcsSession session, BranchId branch, String ... guids) {
        return this.newDataLoaderFromGuids(session, branch, Arrays.asList(guids));
    }

    public DataLoader newDataLoaderFromGuids(OrcsSession session, BranchId branch, Collection<String> guids) {
        Conditions.checkNotNull((Object)branch, (String)"branch");
        Options options = OptionsUtil.createOptions();
        return new DataLoaderImpl(this.logger, options, session, branch, this.loader, guids, this.joinFactory);
    }

    private <T> T adapt(Class<T> clazz, QueryContext queryContext) {
        QueryContext toReturn = null;
        if (!clazz.isAssignableFrom(queryContext.getClass())) {
            throw new OseeCoreException("Invalid query context type [%s] - expected [%s]", new Object[]{queryContext.getClass().getName(), clazz.getName()});
        }
        toReturn = queryContext;
        return (T)toReturn;
    }
}

