/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.exchange.export;

import java.io.IOException;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcDbType;
import org.eclipse.osee.jdbc.SQL3DataType;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.db.internal.exchange.ExportImportXml;
import org.eclipse.osee.orcs.db.internal.exchange.export.AbstractExportItem;
import org.eclipse.osee.orcs.db.internal.exchange.export.AbstractXmlExportItem;
import org.eclipse.osee.orcs.db.internal.exchange.handler.ExportItem;

public class MetadataExportItem
extends AbstractXmlExportItem {
    private final List<AbstractExportItem> exportItems;
    private final JdbcClient jdbcClient;

    public MetadataExportItem(Log logger, List<AbstractExportItem> exportItems, JdbcClient jdbcClient) {
        super(logger, ExportItem.EXPORT_DB_SCHEMA);
        this.exportItems = exportItems;
        this.jdbcClient = jdbcClient;
    }

    @Override
    protected void doWork(Appendable appendable) throws Exception {
        ExportImportXml.openXmlNode(appendable, "metadata");
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (JdbcConnection connection = this.jdbcClient.getConnection();){
                DatabaseMetaData metaData = connection.getMetaData();
                String[] tableTypes = this.getTypes(metaData);
                String schema = this.getSchema(metaData);
                for (AbstractExportItem item : this.exportItems) {
                    if (((Object)((Object)item)).equals((Object)this) || !Strings.isValid((String)item.getSource())) continue;
                    this.processMetaData(appendable, metaData, schema, tableTypes, item.getSource());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            ExportImportXml.closeXmlNode(appendable, "metadata");
        }
    }

    private boolean isTypeAllowed(String type) {
        boolean toReturn = false;
        if (!type.contains("system") && (type.contains("table") || type.contains("synonym") || type.contains("view"))) {
            toReturn = true;
        }
        return toReturn;
    }

    private String[] getTypes(DatabaseMetaData metaData) throws SQLException {
        ArrayList<String> toReturn = new ArrayList<String>();
        try (ResultSet resultSet = null;){
            resultSet = metaData.getTableTypes();
            if (resultSet != null) {
                while (resultSet.next()) {
                    String type = resultSet.getString("TABLE_TYPE");
                    if (!this.isTypeAllowed(type.toLowerCase())) continue;
                    toReturn.add(type);
                }
            }
        }
        return toReturn.toArray(new String[toReturn.size()]);
    }

    private String getSchema(DatabaseMetaData metaData) throws SQLException {
        String toReturn;
        block5: {
            toReturn = "%";
            try (ResultSet resultSet = null;){
                resultSet = metaData.getSchemas();
                if (resultSet == null) break block5;
                while (resultSet.next()) {
                    String rawSchema = resultSet.getString("TABLE_SCHEM");
                    if (!rawSchema.equalsIgnoreCase("osee")) continue;
                    toReturn = String.valueOf(rawSchema) + toReturn;
                    break;
                }
            }
        }
        return toReturn;
    }

    private void processMetaData(Appendable appendable, DatabaseMetaData metaData, String schema, String[] tableTypes, String targetTable) throws Exception {
        block5: {
            try (ResultSet resultSet = null;){
                resultSet = metaData.getTables(null, null, schema, tableTypes);
                if (resultSet == null) break block5;
                while (resultSet.next()) {
                    String tableName = resultSet.getString("TABLE_NAME");
                    String schemaName = resultSet.getString("TABLE_SCHEM");
                    if (!targetTable.equalsIgnoreCase(tableName)) continue;
                    ExportImportXml.openPartialXmlNode(appendable, "table");
                    ExportImportXml.addXmlAttribute(appendable, "name", tableName.toLowerCase());
                    ExportImportXml.endOpenedPartialXmlNode(appendable);
                    this.processColumnMetaData(appendable, metaData, schemaName, tableName);
                    ExportImportXml.closeXmlNode(appendable, "table");
                    break;
                }
            }
        }
    }

    private void processColumnMetaData(Appendable appendable, DatabaseMetaData metaData, String schema, String tableName) throws SQLException, IOException {
        try (ResultSet resultSet = null;){
            try {
                resultSet = metaData.getColumns(null, schema, tableName, null);
            }
            catch (SQLException sQLException) {
                resultSet = metaData.getColumns(null, null, tableName, null);
            }
            if (resultSet != null) {
                while (resultSet.next()) {
                    ExportImportXml.openPartialXmlNode(appendable, "column");
                    try {
                        String columnId = resultSet.getString("COLUMN_NAME").toLowerCase();
                        ExportImportXml.addXmlAttribute(appendable, "id", columnId);
                        int dataType = resultSet.getInt("DATA_TYPE");
                        if (JdbcDbType.getDbType((DatabaseMetaData)metaData).equals((Object)JdbcDbType.foxpro) && dataType == 1) {
                            dataType = 12;
                        }
                        String dataTypeName = SQL3DataType.get((int)dataType).name();
                        ExportImportXml.addXmlAttribute(appendable, "type", dataTypeName);
                    }
                    finally {
                        ExportImportXml.closePartialXmlNode(appendable);
                    }
                }
            }
        }
    }
}

