/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.callable;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcDbType;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.db.internal.callable.AbstractDatastoreTxCallable;

public class PurgeBranchDatabaseCallable
extends AbstractDatastoreTxCallable<Void> {
    private static final String DELETE_FROM_BRANCH_TABLE = "DELETE FROM osee_branch WHERE branch_id = ?";
    private static final String DELETE_FROM_MERGE = "DELETE FROM osee_merge WHERE merge_branch_id = ?";
    private static final String DELETE_FROM_CONFLICT = "DELETE FROM osee_conflict WHERE merge_branch_id = ?";
    private static final String DELETE_FROM_TX_DETAILS = "DELETE FROM osee_tx_details WHERE branch_id = ?";
    private final String DELETE_ARTIFACT_ACL_FROM_BRANCH = "DELETE FROM OSEE_ARTIFACT_ACL WHERE  branch_id =?";
    private final String SELECT_MERGE_BRANCHES = "SELECT merge_branch_id, archived FROM osee_merge, osee_branch where merge_branch_id = branch_id and (source_branch_id = ? or dest_branch_id = ?)";
    private static final String TEMPORARY_BRANCH_UPDATE = "UPDATE osee_branch SET baseline_transaction_id = 1 WHERE branch_id = ?";
    private final Branch toDelete;

    public PurgeBranchDatabaseCallable(Log logger, OrcsSession session, JdbcClient jdbcClient, Branch toDelete) {
        super(logger, session, jdbcClient);
        this.toDelete = toDelete;
    }

    @Override
    protected Void handleTxWork(JdbcConnection connection) {
        List<Pair<BranchId, Boolean>> branches = this.findMergeBranches(connection);
        branches.add((Pair<BranchId, Boolean>)new Pair((Object)this.toDelete, (Object)this.toDelete.isArchived()));
        for (Pair<BranchId, Boolean> toPurge : branches) {
            this.purgeBranch(connection, (BranchId)toPurge.getFirst(), (Boolean)toPurge.getSecond());
        }
        return null;
    }

    private void purgeBranch(JdbcConnection connection, BranchId branch, boolean isArchived) {
        String sourceTableName = isArchived ? "osee_txs_archived" : "osee_txs";
        String sql = String.format("DELETE FROM %s WHERE branch_id = ?", sourceTableName);
        this.purgeFromTable(connection, sql, 0.2, branch);
        if (this.getJdbcClient().getDbType().equals((Object)JdbcDbType.hsql) || this.getJdbcClient().getDbType().equals((Object)JdbcDbType.mysql)) {
            this.purgeFromTable(connection, TEMPORARY_BRANCH_UPDATE, 0.01, branch);
        }
        this.purgeFromTable(connection, DELETE_FROM_TX_DETAILS, 0.09, branch);
        this.purgeFromTable(connection, DELETE_FROM_CONFLICT, 0.01, branch);
        this.purgeFromTable(connection, DELETE_FROM_MERGE, 0.01, branch);
        this.purgeFromTable(connection, DELETE_FROM_BRANCH_TABLE, 0.01, branch);
        this.purgeFromTable(connection, "DELETE FROM OSEE_ARTIFACT_ACL WHERE  branch_id =?", 0.01, branch);
    }

    private List<Pair<BranchId, Boolean>> findMergeBranches(JdbcConnection connection) {
        LinkedList<Pair<BranchId, Boolean>> toReturn = new LinkedList<Pair<BranchId, Boolean>>();
        this.getJdbcClient().runQuery(connection, stmt -> {
            boolean bl = toReturn.add(new Pair((Object)BranchId.valueOf((Long)stmt.getLong("merge_branch_id")), (Object)stmt.getBoolean("archived")));
        }, "SELECT merge_branch_id, archived FROM osee_merge, osee_branch where merge_branch_id = branch_id and (source_branch_id = ? or dest_branch_id = ?)", new Object[]{this.toDelete, this.toDelete});
        return toReturn;
    }

    private void purgeFromTable(JdbcConnection connection, String sql, double percentage, Object ... data) {
        this.checkForCancelled();
        this.getJdbcClient().runPreparedUpdate(connection, sql, data);
    }
}

