/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.callable;

import java.util.ArrayList;
import org.eclipse.osee.framework.core.enums.PermissionEnum;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcTransaction;
import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.data.CreateBranchData;

public final class BranchInheritACLCallable
extends JdbcTransaction {
    private final String GET_BRANCH_ACCESS_CONTROL_LIST = "SELECT permission_id, privilege_entity_id FROM osee_branch_acl WHERE branch_id= ?";
    private final CreateBranchData branchData;
    private final JdbcClient jdbcClient;

    public BranchInheritACLCallable(JdbcClient jdbcClient, CreateBranchData branchData) {
        this.jdbcClient = jdbcClient;
        this.branchData = branchData;
    }

    public void handleTxWork(JdbcConnection connection) {
        int read = PermissionEnum.READ.getPermId();
        int write = PermissionEnum.WRITE.getPermId();
        ArrayList data = new ArrayList();
        this.jdbcClient.runQueryWithMaxFetchSize(stmt -> {
            int permissionId = stmt.getInt("permission_id");
            Long priviledgeId = stmt.getLong("privilege_entity_id");
            if (permissionId == read) {
                permissionId = write;
            }
            data.add(new Object[]{this.branchData.getBranch(), priviledgeId, permissionId});
        }, "SELECT permission_id, privilege_entity_id FROM osee_branch_acl WHERE branch_id= ?", new Object[]{this.branchData.getParentBranch()});
        if (!data.isEmpty()) {
            this.jdbcClient.runBatchUpdate(OseeDb.OSEE_BRANCH_ACL_TABLE.getInsertSql(), data);
        }
    }
}

