/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.Path;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workdef.IRelationResolver;
import org.eclipse.osee.ats.api.workflow.AtsTeamWfEndpointApi;
import org.eclipse.osee.ats.api.workflow.IAtsGoal;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;

@Path(value="teamwf")
public class AtsTeamWfEndpointImpl
implements AtsTeamWfEndpointApi {
    private final AtsApi atsApi;

    public AtsTeamWfEndpointImpl(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public List<ChangeItem> getChangeData(String id) {
        IAtsWorkItem workItem = this.atsApi.getWorkItemService().getWorkItemByAnyId(id);
        if (!workItem.isTeamWorkflow()) {
            throw new UnsupportedOperationException();
        }
        IAtsTeamWorkflow teamWf = workItem.getParentTeamWorkflow();
        TransactionToken trans = this.atsApi.getBranchService().getEarliestTransactionId(teamWf);
        if (trans.isValid()) {
            return this.atsApi.getBranchService().getChangeData((TransactionId)trans);
        }
        BranchToken branch = this.atsApi.getBranchService().getWorkingBranch(teamWf);
        if (branch.isValid()) {
            return this.atsApi.getBranchService().getChangeData((BranchId)branch);
        }
        return Collections.emptyList();
    }

    public IAtsTeamWorkflow getTeamWorkflow(String id) {
        IAtsWorkItem workItem = this.atsApi.getWorkItemService().getWorkItemByAnyId(id);
        if (workItem == null || !workItem.isTeamWorkflow()) {
            throw new UnsupportedOperationException();
        }
        return (IAtsTeamWorkflow)workItem;
    }

    public Collection<IAtsVersion> getVersionsbyTeamDefinition(String aiId, String sort) {
        IAtsActionableItem ai = this.atsApi.getActionableItemService().getActionableItem(aiId);
        IAtsTeamDefinition impactedTeamDef = this.atsApi.getTeamDefinitionService().getImpactedTeamDef(ai);
        IAtsTeamDefinition teamDefHoldingVersions = this.atsApi.getTeamDefinitionService().getTeamDefinitionHoldingVersions(impactedTeamDef);
        ArrayList<IAtsVersion> versionsList = new ArrayList<IAtsVersion>(this.atsApi.getVersionService().getVersions(teamDefHoldingVersions));
        if ("true".equals(sort)) {
            Collections.sort(versionsList);
        }
        return versionsList;
    }

    public XResultData addChangeIds(String workItemId, String teamId, UserId userId, List<String> changeIds) {
        XResultData rd = new XResultData();
        rd.setTitle("Add Change Ids: " + changeIds);
        IAtsWorkItem workItem = this.atsApi.getWorkItemService().getWorkItemByAnyId(workItemId);
        if (workItem == null) {
            rd.errorf("%s is not a valid team workflow id.", new Object[]{workItemId});
            return rd;
        }
        if (!workItem.isTeamWorkflow()) {
            rd.errorf("%s is not a valid team workflow id.", new Object[]{workItem.toStringWithId()});
            return rd;
        }
        IAtsTeamWorkflow teamWf = (IAtsTeamWorkflow)workItem;
        if (teamWf.isCompletedOrCancelled()) {
            rd.errorf("%s is completed/cancelled and cannot be updated.", new Object[]{teamWf.toStringWithId()});
            return rd;
        }
        TeamDefinition passedTeamDef = this.atsApi.getTeamDefinitionService().getTeamDefinitionById(ArtifactId.valueOf((String)teamId));
        if (passedTeamDef == null) {
            rd.errorf("%s is an invalid Team Definition Id", new Object[]{teamId});
            return rd;
        }
        if (!teamWf.getTeamDefinition().getIdString().equals(teamId) && !passedTeamDef.getChildrenTeamDefs().contains(teamWf.getTeamDefinition())) {
            rd.errorf("Workflow %s has a Team Definition %s which does not match/nor is the child of the passed in Team Definition %s", new Object[]{teamWf.toStringWithId(), teamWf.getTeamDefinition().toStringWithId(), passedTeamDef.toStringWithId()});
            return rd;
        }
        if (userId.isInvalid()) {
            rd.errorf("%s is an invalid ATS userId", new Object[]{userId});
            return rd;
        }
        AtsUser asUser = this.atsApi.getUserService().getUserByAccountId(userId);
        if (asUser.isInvalid()) {
            rd.errorf("%s is an invalid ATS userId", new Object[]{userId});
            return rd;
        }
        IAtsChangeSet changes = this.atsApi.createChangeSet("Add Change Id(s)", asUser);
        HashSet<String> distinctChangeIds = new HashSet<String>(this.atsApi.getAttributeResolver().getAttributesToStringList((IAtsObject)workItem, (AttributeTypeToken)CoreAttributeTypes.GitChangeId));
        distinctChangeIds.addAll(changeIds);
        ArrayList updatedChangeIdsList = new ArrayList(distinctChangeIds);
        changes.setAttributeValuesAsStrings((IAtsObject)workItem, (AttributeTypeToken)CoreAttributeTypes.GitChangeId, updatedChangeIdsList);
        changes.executeIfNeeded();
        return rd;
    }

    public List<IAtsGoal> getGoals(String id) {
        IAtsWorkItem workItem = this.atsApi.getWorkItemService().getWorkItemByAnyId(id);
        if (!workItem.isTeamWorkflow()) {
            throw new UnsupportedOperationException();
        }
        Collection artifacts = this.atsApi.getRelationResolver().getRelated(workItem.getArtifactId(), AtsRelationTypes.Goal_Goal);
        ArrayList<IAtsGoal> goalList = new ArrayList<IAtsGoal>();
        for (ArtifactToken art : artifacts) {
            goalList.add(this.atsApi.getWorkItemService().getGoal(art));
        }
        return goalList;
    }

    public Collection<ArtifactToken> getWfByRelease(String releaseName) {
        Collection releases = this.atsApi.getQueryService().createQuery(new ArtifactTypeToken[]{AtsArtifactTypes.ReleaseArtifact}).andName(releaseName).getArtifacts();
        if (releases.size() > 1) {
            throw new OseeCoreException("Release Name [%s] matches multiple releases", new Object[]{releaseName});
        }
        if (releases.isEmpty()) {
            throw new OseeCoreException("No Releases found with name [%s]", new Object[]{releaseName});
        }
        ArtifactToken release = (ArtifactToken)releases.iterator().next();
        IRelationResolver relationResolver = this.atsApi.getRelationResolver();
        return relationResolver.getRelated((ArtifactId)release, AtsRelationTypes.TeamWorkflowToRelease_TeamWorkflow);
    }

    public XResultData relateReleaseToWorkflow(String build, UserId userId, List<String> changeIds) {
        XResultData rd = new XResultData();
        try {
            rd.setTitle("Add Workflow to Release Relations");
            Collection allWorkflows = this.atsApi.getQueryService().createQuery(new ArtifactTypeToken[]{AtsArtifactTypes.TeamWorkflow}).andAttr((AttributeTypeId)CoreAttributeTypes.GitChangeId, changeIds, new QueryOption[0]).getArtifacts();
            AtsUser asUser = this.atsApi.getUserService().getUserByAccountId(userId);
            if (asUser.isInvalid()) {
                rd.errorf("%s is an invalid ATS user.", new Object[]{userId});
                return rd;
            }
            IAtsChangeSet changes = this.atsApi.createChangeSet("Add Build Incorporation(s)", asUser);
            ArrayList<IAtsWorkItem> workItems = new ArrayList<IAtsWorkItem>();
            for (IAtsWorkItem workItem : this.atsApi.getWorkItemService().getWorkItems(allWorkflows)) {
                if (!workItem.isTeamWorkflow()) {
                    rd.errorf("%s is not a valid team workflow id.", new Object[]{workItem.toStringWithId()});
                    return rd;
                }
                workItems.add(workItem);
                HashSet distinctChangeIds = new HashSet(this.atsApi.getAttributeResolver().getAttributesToStringList((IAtsObject)workItem, (AttributeTypeToken)CoreAttributeTypes.GitChangeId));
                boolean isBuildValid = false;
                for (String changeId : changeIds) {
                    if (!distinctChangeIds.contains(changeId)) continue;
                    isBuildValid = true;
                    break;
                }
                Collection release = this.atsApi.getQueryService().createQuery(new ArtifactTypeToken[]{AtsArtifactTypes.ReleaseArtifact}).andName(build).getArtifacts();
                if (!isBuildValid) continue;
                if (release.size() > 1) {
                    rd.errorf("Release Name [%s] matches multiple releases", new Object[]{build});
                    return rd;
                }
                if (release.isEmpty()) {
                    rd.errorf("No Releases found with name [%s]", new Object[]{build});
                    return rd;
                }
                IRelationResolver relationResolver = this.atsApi.getRelationResolver();
                if (relationResolver.areRelated(workItem.getArtifactId(), AtsRelationTypes.TeamWorkflowToRelease_Release, (ArtifactId)release.stream().findFirst().get())) continue;
                changes.relate((Object)workItem, AtsRelationTypes.TeamWorkflowToRelease_Release, release.stream().findFirst().get());
            }
            TransactionToken transId = changes.executeIfNeeded();
            rd.setTxId(transId.getIdString());
        }
        catch (Exception Ex) {
            rd.errorf("Exception %s", new Object[]{Lib.exceptionToString((Exception)Ex)});
        }
        return rd;
    }
}

