/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.EmailUtil;

public class EmailGroup {
    private final String groupName;
    private final ArrayList<String> emails = new ArrayList();

    public EmailGroup(String groupName, Collection<String> emails) {
        this.setEmails(emails);
        this.groupName = groupName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public boolean hasEmails() {
        if (this.emails.isEmpty()) {
            return false;
        }
        for (String str : this.emails) {
            if (!EmailUtil.isEmailValid(str)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.groupName) + " (" + Collections.toString("; ", this.emails) + ")";
    }

    public ArrayList<String> getEmails() {
        return this.emails;
    }

    public void setEmails(Collection<String> emails) {
        this.emails.clear();
        for (String str : emails) {
            if (!EmailUtil.isEmailValid(str)) continue;
            this.emails.add(str);
        }
    }
}

