/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

public class DateUtil {
    public static final long MILLISECONDS_IN_A_WEEK = 604800000L;
    public static final long MILLISECONDS_IN_A_DAY = 86400000L;
    public static final String MMDDYY = "MM/dd/yyyy";
    public static final String YYYYMMDD = "yyyy/MM/dd";
    public static final String YYYY_MM_DD = "yyyy_MM_dd";
    public static final String YYYY_MM_DD_WITH_DASHES = "yyyy-MM-dd";
    public static final String MMDDYYHHMM = "MM/dd/yyyy hh:mm a";
    public static final String HHMMSS = "hh:mm:ss";
    public static final String HHMMSSSS = "hh:mm:ss:SS";
    public static final String HHMM = "hh:mm";
    public static final HashMap<String, DateFormat> dateFormats = new HashMap();
    private static Date SENTINAL = null;

    public static Calendar getCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static int getWorkingDaysBetween(Date fromDate, Date toDate) {
        return DateUtil.getWorkingDaysBetween(DateUtil.getCalendar(fromDate), DateUtil.getCalendar(toDate));
    }

    public static boolean isWeekDay(Calendar cal) {
        return cal.get(7) != 7 && cal.get(7) != 1;
    }

    public static Date getDate(String format, String value) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        Date date = formatter.parse(value);
        return date;
    }

    public static int getWorkingDaysBetween(Calendar fromDate, Calendar toDate) {
        int workingDays = 0;
        while (!fromDate.after(toDate)) {
            int day = fromDate.get(7);
            if (day != 7 && day != 1) {
                ++workingDays;
            }
            fromDate.add(5, 1);
        }
        return workingDays;
    }

    public static String getHHMM(Date date) {
        return DateUtil.get(date, HHMM);
    }

    public static String getHHMMSS(Date date) {
        return DateUtil.get(date, HHMMSS);
    }

    public static String getYYYYMMDD() {
        return DateUtil.getYYYYMMDD(new Date());
    }

    public static String getYYYYMMDD(Date date) {
        return DateUtil.get(date, YYYYMMDD);
    }

    public static String getMMDDYY(Date date) {
        return DateUtil.get(date, MMDDYY);
    }

    public static String getMMDDYYHHMM() {
        return DateUtil.getMMDDYYHHMM(new Date());
    }

    public static String getMMDDYYHHMM(Date date) {
        return DateUtil.get(date, MMDDYYHHMM);
    }

    public static String getDateNow() {
        return DateUtil.getDateNow(new Date());
    }

    public static String getDateNow(Date date) {
        return DateUtil.getDateNow(date, MMDDYY);
    }

    public static String getTimeStamp() {
        return DateUtil.getDateNow(new Date(), HHMMSSSS);
    }

    public static String getDateStr(Date date, String format) {
        if (date == null) {
            return "";
        }
        DateFormat dateFormat = dateFormats.get(format);
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat(format);
            dateFormats.put(format, dateFormat);
        }
        return dateFormat.format(date);
    }

    public static String getDateNow(String format) {
        return DateUtil.get(new Date(), format);
    }

    public static String getDateNow(Date date, String format) {
        return DateUtil.get(date, format);
    }

    public static String get(Date date) {
        if (date == null) {
            return "";
        }
        return DateFormat.getDateInstance().format(date);
    }

    public static String get(Date date, String pattern) {
        return DateUtil.get(date, new SimpleDateFormat(pattern));
    }

    public static String get(Date date, DateFormat dateFormat) {
        if (date == null) {
            return "";
        }
        String result = dateFormat.format(date);
        return result;
    }

    public static int getDifference(Date a, Date b) {
        int tempDifference = 0;
        int difference = 0;
        Calendar earlier = Calendar.getInstance();
        Calendar later = Calendar.getInstance();
        if (a.compareTo(b) < 0) {
            earlier.setTime(a);
            later.setTime(b);
        } else {
            earlier.setTime(b);
            later.setTime(a);
        }
        while (earlier.get(1) != later.get(1)) {
            tempDifference = 365 * (later.get(1) - earlier.get(1));
            difference += tempDifference;
            earlier.add(6, tempDifference);
        }
        if (earlier.get(6) != later.get(6)) {
            tempDifference = later.get(6) - earlier.get(6);
            difference += tempDifference;
            earlier.add(6, tempDifference);
        }
        return difference;
    }

    public static double getInterpolationRatioBetweenDates(Date startDate, Date endDate, Date interDate) {
        double interRatio = 0.0;
        if (interDate.before(startDate) || interDate.compareTo(startDate) == 0) {
            return 0.0;
        }
        if (interDate.after(endDate) || interDate.compareTo(endDate) == 0) {
            return 1.0;
        }
        if (endDate.before(startDate)) {
            return 0.0;
        }
        long startMillis = startDate.getTime();
        long endMillis = endDate.getTime();
        long interMillis = interDate.getTime();
        long rangeMillis = endMillis - startMillis;
        if ((double)rangeMillis == 0.0) {
            return 0.0;
        }
        long normalizedInterMillis = interMillis - startMillis;
        interRatio = (double)normalizedInterMillis / (double)rangeMillis;
        return interRatio;
    }

    public static Date addWeeks(Date date, int manyWeeks) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(3, manyWeeks);
        return cal.getTime();
    }

    public static int getManyWeeksDifference(Date a, Date b) {
        Calendar endCal;
        Calendar startCal;
        int weeks = 0;
        Calendar aCal = Calendar.getInstance();
        Calendar bCal = Calendar.getInstance();
        aCal.setTime(a);
        bCal.setTime(b);
        if (aCal.before(bCal)) {
            startCal = aCal;
            endCal = bCal;
        } else {
            startCal = bCal;
            endCal = aCal;
        }
        while (startCal.before(endCal)) {
            startCal.add(3, 1);
            ++weeks;
        }
        return weeks;
    }

    public static Date getMondayBefore(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        while (cal.get(7) != 2) {
            cal.add(5, -1);
        }
        return cal.getTime();
    }

    public static Date getMondayAfter(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        while (cal.get(7) != 2) {
            cal.add(5, 1);
        }
        return cal.getTime();
    }

    public static Date convertToStartOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    public static Date convertToEndOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static Date getSentinalDate() {
        if (SENTINAL == null) {
            Calendar cal = Calendar.getInstance();
            cal.set(1, 2001);
            cal.set(5, 1);
            cal.set(2, 1);
            cal.set(11, 1);
            cal.set(12, 1);
            cal.set(13, 1);
            SENTINAL = cal.getTime();
        }
        return SENTINAL;
    }
}

