/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.util;

import java.util.StringTokenizer;
import org.eclipse.osee.disposition.model.LocationRange;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;

public final class LocationRangeUtil {
    public static boolean isValid(int start, int end) {
        boolean result = false;
        if (start > 0 && end > 0 && start <= end) {
            result = true;
        }
        return result;
    }

    public static void checkValid(int start, int end) {
        if (start > end) {
            throw new OseeArgumentException("End Index must be equal to or greater than the Start Index", new Object[0]);
        }
    }

    public static LocationRange newLocationRange(int startIndex, int endIndex) {
        LocationRangeUtil.checkValid(startIndex, endIndex);
        return new LocationRange(startIndex, endIndex);
    }

    public static LocationRange parseLocation(String locationRef) {
        int endFromString;
        int startFromString;
        if ((locationRef = locationRef.trim()).matches("\\d+-\\d+")) {
            StringTokenizer tokenizer = new StringTokenizer(locationRef, "-");
            startFromString = Integer.valueOf(tokenizer.nextToken());
            endFromString = Integer.valueOf(tokenizer.nextToken());
        } else if (locationRef.matches("-\\d+--\\d+")) {
            StringTokenizer tokenizer = new StringTokenizer(locationRef, "-");
            startFromString = -1 * Integer.valueOf(tokenizer.nextToken());
            endFromString = -1 * Integer.valueOf(tokenizer.nextToken());
        } else {
            startFromString = Integer.valueOf(locationRef);
            endFromString = Integer.valueOf(locationRef);
        }
        return LocationRangeUtil.newLocationRange(startFromString, endFromString);
    }

    public static boolean isLocRefWithinRange(LocationRange range, LocationRange locRefRange) {
        return range.getStart() <= locRefRange.getStart() && range.getEnd() >= locRefRange.getEnd();
    }

    public static boolean isCovered(LocationRange range, Iterable<? extends LocationRange> locations) {
        boolean isFullyCovered = false;
        int firstUncoveredIndex = range.getStart();
        int end = range.getEnd();
        for (LocationRange locationRange : locations) {
            if (locationRange.getStart() != firstUncoveredIndex) continue;
            if (locationRange.getEnd() >= end) {
                isFullyCovered = true;
                break;
            }
            firstUncoveredIndex = locationRange.getEnd() + 1;
        }
        return isFullyCovered;
    }
}

