/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.server.internal;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadFactory;
import org.eclipse.osee.framework.core.server.internal.OseeServerThread;

class OseeServerThreadFactory
implements ThreadFactory {
    private final List<WeakReference<OseeServerThread>> threads;
    private final String threadName;
    private final int priority;

    public OseeServerThreadFactory(String threadName, int priority) {
        this.threadName = threadName;
        this.threads = new CopyOnWriteArrayList<WeakReference<OseeServerThread>>();
        this.priority = priority;
    }

    public OseeServerThreadFactory(String name) {
        this(name, 5);
    }

    @Override
    public Thread newThread(Runnable runnable) {
        OseeServerThread thread = new OseeServerThread(runnable, String.valueOf(this.threadName) + ":" + this.threads.size());
        thread.setPriority(this.priority);
        this.threads.add(new WeakReference<OseeServerThread>(thread));
        return thread;
    }

    List<OseeServerThread> getThreads() {
        ArrayList<OseeServerThread> toReturn = new ArrayList<OseeServerThread>();
        for (WeakReference<OseeServerThread> weak : this.threads) {
            OseeServerThread thread = (OseeServerThread)weak.get();
            if (thread == null) continue;
            toReturn.add(thread);
        }
        return toReturn;
    }
}

