/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.server;

import javax.servlet.http.HttpServletRequest;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.core.server.ISession;
import org.eclipse.osee.framework.core.server.ISessionManager;
import org.eclipse.osee.framework.core.server.OseeHttpServlet;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.logger.Log;

public class SecureOseeHttpServlet
extends OseeHttpServlet {
    private static final long serialVersionUID = -4034231476048459552L;
    private final ISessionManager sessionManager;

    public SecureOseeHttpServlet(Log logger, ISessionManager sessionManager) {
        super(logger);
        this.sessionManager = sessionManager;
    }

    protected ISessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Override
    protected void checkAccessControl(HttpServletRequest request) {
        String sessionId = this.getSessionId(request);
        ISession session = this.sessionManager.getSessionById(sessionId);
        Conditions.checkNotNull((Object)session, (String)"session");
    }

    public boolean isInitializing(HttpServletRequest request) {
        String sessionId = this.getSessionId(request);
        ISession session = this.sessionManager.getSessionById(sessionId);
        String userId = session.getUserId();
        return SystemUser.BootStrap.getUserId().equals(userId);
    }

    protected String getSessionId(HttpServletRequest request) {
        return request.getParameter("sessionId");
    }
}

