/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.server;

import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.server.IAuthenticationProvider;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.search.QueryFactory;

public abstract class AbstractAuthenticationProvider
implements IAuthenticationProvider {
    private Log logger;
    private OrcsApi orcsApi;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public Log getLogger() {
        return this.logger;
    }

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    protected OrcsApi getOrcsApi() {
        return this.orcsApi;
    }

    protected UserToken getUserTokenFromOseeDb(String userId) {
        UserToken toReturn = null;
        try {
            QueryFactory queryFactory = this.orcsApi.getQueryFactory();
            QueryBuilder query = queryFactory.fromBranch((BranchId)CoreBranches.COMMON).andTypeEquals(new ArtifactTypeToken[]{CoreArtifactTypes.User}).andAttributeIs((AttributeTypeId)CoreAttributeTypes.UserId, userId);
            ArtifactReadable artifact = (ArtifactReadable)query.getResults().getOneOrDefault((Object)ArtifactReadable.SENTINEL);
            if (artifact.isValid()) {
                toReturn = UserToken.create((long)artifact.getUuid(), (String)artifact.getName(), (String)artifact.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Email, ""), (String)userId, (boolean)true);
            } else {
                this.getLogger().info("Unable to find userId:[%s] on [%s]", new Object[]{userId, CoreBranches.COMMON});
            }
        }
        catch (OseeCoreException ex) {
            this.getLogger().error((Throwable)ex, "Unable to find userId [%s] in OSEE database.", new Object[]{userId});
        }
        return toReturn;
    }

    protected UserToken createUserToken(String userName, String userId, String userEmail) {
        return UserToken.create((String)userName, (String)userEmail, (String)userId);
    }
}

