/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mail.internal;

public final class MailConstants {
    public static final String NAMESPACE = "mail.server";
    public static final String MAIL_SERVER_USERNAME = MailConstants.qualify("username");
    public static final String MAIL_SERVER_PASSWORD = MailConstants.qualify("password");
    public static final String MAIL_SERVER_HOST = MailConstants.qualify("host");
    public static final String MAIL_SERVER_PORT = MailConstants.qualify("port");
    public static final String MAIL_SERVER_TRANSPORT = MailConstants.qualify("transport");
    public static final String MAIL_SERVER_ADMIN_EMAIL = MailConstants.qualify("admin.email");
    public static final String MAIL_SERVER_REPLY_TO_EMAIL = MailConstants.qualify("reply.to.email");
    public static final String MAIL_SERVER_TEST_EMAIL_SUBJECT = MailConstants.qualify("test.email.subject");
    public static final String MAIL_SERVER_TEST_EMAIL_BODY = MailConstants.qualify("test.email.body");
    public static final String MAIL_SERVER_STATUS_WAIT_TIME_MILLIS = MailConstants.qualify("status.wait.time");
    public static final String DEFAULT_MAIL_SERVER_USERNAME = null;
    public static final String DEFAULT_MAIL_SERVER_PASSWORD = null;
    public static final String DEFAULT_MAIL_SERVER_HOST = null;
    public static final int DEFAULT_MAIL_SERVER_PORT = 25;
    public static final String DEFAULT_MAIL_SERVER_TRANSPORT = "smtp";
    public static final String DEFAULT_MAIL_SERVER_ADMIN_EMAIL = null;
    public static final String DEFAULT_MAIL_SERVER_REPLY_TO_EMAIL = null;
    public static final String DEFAULT_MAIL_SERVER_TEST_EMAIL_SUBJECT = "Test Email";
    public static final String DEFAULT_MAIL_SERVER_TEST_EMAIL_BODY = "This is a test email sent from OSEE Mail Service";
    public static final long DEFAULT_MAIL_SERVER_STATUS_WAIT_TIME_MILLIS = 60000L;

    private MailConstants() {
    }

    private static String qualify(String value) {
        return String.format("%s.%s", NAMESPACE, value);
    }
}

