/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.account.admin.internal.validator;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.account.admin.AccountField;
import org.eclipse.osee.account.admin.ds.AccountStorage;
import org.eclipse.osee.account.admin.ds.SubscriptionStorage;
import org.eclipse.osee.account.admin.internal.validator.DisplayNameValidator;
import org.eclipse.osee.account.admin.internal.validator.EmailValidator;
import org.eclipse.osee.account.admin.internal.validator.FieldValidator;
import org.eclipse.osee.account.admin.internal.validator.LocalIdValidator;
import org.eclipse.osee.account.admin.internal.validator.SubscriptionGroupNameValidator;
import org.eclipse.osee.account.admin.internal.validator.UserNameValidator;
import org.eclipse.osee.account.admin.internal.validator.UuidValidator;
import org.eclipse.osee.account.admin.internal.validator.Validator;
import org.eclipse.osee.logger.Log;

public final class Validators {
    public static Comparator<FieldValidator> VALIDATOR_PRIORITY_ORDER_COMPARATOR = new Comparator<FieldValidator>(){

        @Override
        public int compare(FieldValidator o1, FieldValidator o2) {
            Integer priority1 = o1.getPriority();
            Integer priority2 = o2.getPriority();
            return priority1.compareTo(priority2);
        }
    };

    private Validators() {
    }

    public static Validator newAccountValidator(Log logger, AccountStorage storage) {
        HashMap<AccountField, FieldValidator> data = new HashMap<AccountField, FieldValidator>();
        Validators.addValidator(data, new UuidValidator());
        Validators.addValidator(data, new LocalIdValidator());
        Validators.addValidator(data, new DisplayNameValidator(storage));
        Validators.addValidator(data, new EmailValidator(storage));
        Validators.addValidator(data, new UserNameValidator(storage));
        return new Validator(logger, data);
    }

    public static Validator newSubscriptionValidator(Log logger, SubscriptionStorage storage) {
        HashMap<AccountField, FieldValidator> data = new HashMap<AccountField, FieldValidator>();
        Validators.addValidator(data, new UuidValidator());
        Validators.addValidator(data, new LocalIdValidator());
        Validators.addValidator(data, new SubscriptionGroupNameValidator(storage));
        return new Validator(logger, data);
    }

    private static void addValidator(Map<AccountField, FieldValidator> validators, FieldValidator toAdd) {
        validators.put(toAdd.getFieldType(), toAdd);
    }
}

