/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model;

import org.eclipse.osee.framework.core.data.HasBranchId;
import org.eclipse.osee.framework.core.data.TransactionToken;

public final class TransactionDelta {
    private final TransactionToken startTx;
    private final TransactionToken endTx;

    public TransactionDelta(TransactionToken startTx, TransactionToken endTx) {
        this.startTx = startTx;
        this.endTx = endTx;
    }

    public TransactionToken getStartTx() {
        return this.startTx;
    }

    public TransactionToken getEndTx() {
        return this.endTx;
    }

    public boolean areOnTheSameBranch() {
        return this.startTx.isOnSameBranch((HasBranchId)this.endTx);
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof TransactionDelta) {
            boolean left;
            TransactionDelta other = (TransactionDelta)obj;
            boolean bl = this.startTx == null ? other.startTx == null : (left = this.startTx.equals(other.startTx));
            boolean right = this.endTx == null ? other.endTx == null : this.endTx.equals(other.endTx);
            result = left && right;
        }
        return result;
    }

    public int hashCode() {
        int result = 17;
        result = this.startTx != null ? 37 * result + this.startTx.hashCode() : (result *= 37);
        result = this.endTx != null ? 37 * result + this.endTx.hashCode() : (result *= 37);
        return result;
    }

    public String toString() {
        String firstString = String.valueOf(this.getStartTx());
        String secondString = String.valueOf(this.getEndTx());
        return String.format("[start:%s, end:%s]", firstString, secondString);
    }
}

