/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.writer;

import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.xml.RowProcessor;
import org.eclipse.osee.orcs.rest.internal.writer.OrcsWriterFactory;
import org.eclipse.osee.orcs.rest.internal.writer.OrcsWriterUtil;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwArtifactToken;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwCollector;

public class OrcsWriterSheetProcessorForDelete
implements RowProcessor {
    private final OwCollector collector;
    private int rowCount = 0;
    private final OrcsWriterFactory factory;
    private final XResultData result;

    public OrcsWriterSheetProcessorForDelete(OwCollector collector, XResultData result) {
        this.collector = collector;
        this.result = result;
        this.factory = new OrcsWriterFactory(collector);
    }

    public void detectedRowAndColumnCounts(int rowCount, int columnCount) {
    }

    public void foundStartOfWorksheet(String sheetName) {
    }

    public void processCommentRow(String[] row) {
    }

    public void processEmptyRow() {
    }

    public void processHeaderRow(String[] headerRow) {
        ++this.rowCount;
        if (headerRow.length > 1) {
            this.result.warning("More than 1 column found in DELETE sheet.  Only column 1 is processed");
        }
    }

    public void processRow(String[] row) {
        ++this.rowCount;
        OwArtifactToken artifact = null;
        String value = row[0];
        if (Strings.isNumeric((String)value)) {
            artifact = new OwArtifactToken(Long.valueOf(value), "unknown");
        }
        if (Strings.isValid((String)value)) {
            artifact = this.factory.getOrCreateToken(value);
        }
        if (artifact != null) {
            artifact.setData(OrcsWriterUtil.getData("DELETE", this.rowCount, 0, value));
            this.collector.getDelete().add(artifact);
        }
    }

    public void reachedEndOfWorksheet() {
    }
}

