/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.writer;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.ws.rs.core.StreamingOutput;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.rest.internal.writer.IcdGenerator;

public final class IcdStreamingOutput
implements StreamingOutput {
    private final OrcsApi orcsApi;
    private final BranchId branch;
    private final String connectionName;

    public IcdStreamingOutput(OrcsApi orcsApi, BranchId branch, String connectionName) {
        this.orcsApi = orcsApi;
        this.branch = branch;
        this.connectionName = connectionName;
    }

    public void write(OutputStream output) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(output);
            IcdGenerator generator = new IcdGenerator(this.orcsApi);
            generator.runOperation(this.orcsApi, writer, this.branch, this.connectionName);
        }
        catch (Exception ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
    }
}

