/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.writer;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.token.InterfaceStructureCategoryAttribute;
import org.eclipse.osee.framework.jdk.core.util.CellData;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.ArtifactReadableImpl;

public class IcdGenerator {
    private final OrcsApi orcsApi;

    public IcdGenerator(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public void runOperation(OrcsApi providedOrcs, Writer providedWriter, BranchId branch, String connectionName) throws IOException {
        ArtifactReadable conn = this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.InterfaceConnection}).andNameEquals(connectionName).getArtifact();
        ArtifactReadable primaryNode = (ArtifactReadable)conn.getRelated(CoreRelationTypes.InterfaceConnectionPrimary_Node).getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
        ArtifactReadable secondaryNode = (ArtifactReadable)conn.getRelated(CoreRelationTypes.InterfaceConnectionSecondary_Node).getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
        List messages = conn.getRelated(CoreRelationTypes.InterfaceConnectionContent_Message).getList();
        ArrayList<ArtifactReadable> subMessages = new ArrayList<ArtifactReadable>();
        ArrayList structures = new ArrayList();
        TreeMap<String, String> structureLinks = new TreeMap<String, String>();
        for (ArtifactReadable message : messages) {
            subMessages.addAll(message.getRelated(CoreRelationTypes.InterfaceMessageSubMessageContent_SubMessage).getList());
        }
        for (ArtifactReadable subMessage : subMessages) {
            structures.addAll(subMessage.getRelated(CoreRelationTypes.InterfaceSubMessageContent_Structure).getList());
        }
        int worksheetIndex = 0;
        for (ArtifactReadable structure : structures) {
            ++worksheetIndex;
            String sheetName = structure.getName().replace("Command Taskfile", "CT").replace("Status Taskfile", "ST");
            if (sheetName.length() > 30) {
                sheetName = String.valueOf(sheetName.substring(0, 25)) + "_" + Integer.toString(worksheetIndex);
            }
            structureLinks.put(structure.getName(), sheetName);
        }
        ExcelXmlWriter writer = new ExcelXmlWriter(providedWriter);
        this.createMessageSubMessageSummary(writer, branch, conn, primaryNode, secondaryNode, messages);
        this.createStructureNamesSheet(writer, branch, structureLinks);
        this.createMessageDetailSheet(writer, branch, subMessages, structureLinks);
        this.createSubMessageSheets(writer, branch, subMessages, structureLinks);
        writer.endWorkbook();
    }

    private void createStructureNamesSheet(ExcelXmlWriter writer, BranchId branch, SortedMap<String, String> structures) throws IOException {
        ArrayList<String> headingsList = new ArrayList<String>();
        headingsList.add("Structure Name");
        headingsList.add("Structure Name");
        headingsList.add("Structure Name");
        Object[] headings = headingsList.toArray();
        int columnCount = 3;
        writer.startSheet("Structures Names", columnCount);
        writer.writeHeaderRow(headings);
        Iterator<String> iterator = structures.keySet().iterator();
        int size = structures.size();
        int firstCol = Math.floorDiv(size, 3);
        int secCol = firstCol * 2;
        int count = 0;
        TreeMap<String, String> col1 = new TreeMap<String, String>();
        TreeMap<String, String> col2 = new TreeMap<String, String>();
        TreeMap<String, String> col3 = new TreeMap<String, String>();
        while (iterator.hasNext()) {
            String sName = iterator.next();
            String sLink = (String)structures.get(sName);
            if (count < firstCol) {
                col1.put(sName, sLink);
            } else if (count < secCol) {
                col2.put(sName, sLink);
            } else {
                col3.put(sName, sLink);
            }
            ++count;
        }
        Iterator col1Iterator = col1.keySet().iterator();
        Iterator col2Iterator = col2.keySet().iterator();
        Iterator col3Iterator = col3.keySet().iterator();
        while (col1Iterator.hasNext()) {
            CellData name = new CellData();
            name.setText((String)col1Iterator.next());
            name.setHyperlink((String)col1.get(name.getText()));
            writer.writeCell((Object)name);
            if (col2Iterator.hasNext()) {
                name.setText((String)col2Iterator.next());
                name.setHyperlink((String)col2.get(name.getText()));
                writer.writeCell((Object)name);
            }
            if (col3Iterator.hasNext()) {
                name.setText((String)col3Iterator.next());
                name.setHyperlink((String)col3.get(name.getText()));
                writer.writeCell((Object)name);
            }
            writer.endRow();
        }
        writer.endSheet();
    }

    private void createMessageDetailSheet(ExcelXmlWriter writer, BranchId branch, List<ArtifactReadable> subMessages, SortedMap<String, String> structureLinks) throws IOException {
        ArrayList<String> headingsList = new ArrayList<String>();
        int columnCount = 14;
        headingsList.add("Category");
        headingsList.add("SubMessage Name");
        headingsList.add("Tx Rate");
        headingsList.add("Sim Min");
        headingsList.add("Sim Max");
        headingsList.add("# of Attributes");
        headingsList.add("Size in Bytes");
        headingsList.add("BPS Min");
        headingsList.add("BPS Max");
        headingsList.add("Initiator");
        headingsList.add("Msg #");
        headingsList.add("SubMsg #");
        headingsList.add("Taskfile Type");
        headingsList.add("Description");
        Object[] headings = headingsList.toArray();
        writer.startSheet("SubMessage Summary", columnCount);
        writer.writeHeaderRow(headings);
        for (ArtifactReadable artifact : subMessages) {
            for (ArtifactReadable struct : artifact.getRelated(CoreRelationTypes.InterfaceSubMessageContent_Structure).getList()) {
                String msgRateText;
                String sheetName = (String)structureLinks.get(struct.getName());
                List elements = struct.getRelated(CoreRelationTypes.InterfaceStructureContent_DataElement).getList();
                Integer sum = 0;
                for (ArtifactReadable element : struct.getRelated(CoreRelationTypes.InterfaceStructureContent_DataElement).getList()) {
                    ArtifactReadable platformType = (ArtifactReadable)element.getRelated(CoreRelationTypes.InterfaceElementPlatformType_PlatformType).getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
                    sum = element.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.InterfaceDataElementArray}) ? Integer.valueOf(sum + Integer.parseInt(platformType.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfacePlatformTypeBitSize, "0")) * (Integer.parseInt(element.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceElementIndexEnd)) - Integer.parseInt(element.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceElementIndexStart)) + 1) / 8) : Integer.valueOf(sum + Integer.parseInt(platformType.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfacePlatformTypeBitSize, "0")) / 8);
                }
                ArtifactReadable message = (ArtifactReadable)artifact.getRelated(CoreRelationTypes.InterfaceMessageSubMessageContent_Message).getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
                String sendingNode = ((ArtifactReadable)message.getRelated(CoreRelationTypes.InterfaceMessageSendingNode_Node).getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL)).getName();
                String msgNumber = message.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageNumber, "0");
                String minSim = struct.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMinSimultaneity, "n/a");
                String maxSim = struct.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMaxSimultaneity, "n/a");
                int msgRate = -1;
                String msgPeriodicity = message.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessagePeriodicity, "Aperiodic");
                if (msgPeriodicity.equals("Periodic")) {
                    msgRateText = message.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageRate, "Error");
                    try {
                        msgRate = Integer.parseInt(msgRateText);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    msgRateText = msgPeriodicity;
                }
                if (artifact.getExistingAttributeTypes().contains(CoreAttributeTypes.InterfaceMessageRate)) {
                    msgRateText = artifact.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageRate, "Error");
                    try {
                        msgRate = Integer.parseInt(msgRateText);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    if (msgPeriodicity.equals("Aperiodic")) {
                        msgRateText = String.valueOf(msgRateText) + "-A";
                    }
                }
                String minBps = "Classified";
                String maxBps = "Classified";
                if (msgRate > 0) {
                    try {
                        minBps = Integer.toString(Integer.parseInt(minSim) * sum * msgRate);
                    }
                    catch (NumberFormatException numberFormatException) {
                        minBps = "Classified";
                    }
                    try {
                        maxBps = Integer.toString(Integer.parseInt(maxSim) * sum * msgRate);
                    }
                    catch (NumberFormatException numberFormatException) {
                        maxBps = "Classified";
                    }
                }
                String cat = (String)struct.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InterfaceStructureCategory);
                InterfaceStructureCategoryAttribute.InterfaceStructureCategoryEnum catEnum = CoreAttributeTypes.InterfaceStructureCategory.getEnumValues().stream().filter(e -> cat.equals(e.getName())).findAny().orElse(null);
                writer.writeCell((Object)(catEnum.getId() + " " + catEnum.getName()));
                CellData name = new CellData((String)struct.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Name), sheetName, "", "");
                writer.writeCell((Object)name);
                writer.writeCell((Object)msgRateText);
                writer.writeCell((Object)minSim);
                writer.writeCell((Object)maxSim);
                int elementCount = 1;
                if (elements.size() != 0) {
                    elementCount = elements.size();
                }
                writer.writeCell((Object)elementCount);
                writer.writeCell((Object)sum);
                writer.writeCell((Object)minBps);
                writer.writeCell((Object)maxBps);
                writer.writeCell((Object)sendingNode);
                writer.writeCell((Object)msgNumber);
                writer.writeCell((Object)artifact.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceSubMessageNumber, "n/a"));
                writer.writeCell((Object)struct.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceTaskFileType, "n/a"));
                writer.writeCell((Object)struct.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Description, ""));
                writer.endRow();
            }
        }
        writer.endSheet();
    }

    private void createSubMessageSheets(ExcelXmlWriter writer, BranchId branch, List<ArtifactReadable> subMessages, SortedMap<String, String> structureLinks) throws IOException {
        ArrayList<String> headingsList = new ArrayList<String>();
        int columnCount = 13;
        headingsList.add("Begin Word");
        headingsList.add("Begin Byte");
        headingsList.add("Number of Bytes");
        headingsList.add("Ending Word");
        headingsList.add("Ending Byte");
        headingsList.add("Type");
        headingsList.add("Element Name");
        headingsList.add("Units");
        headingsList.add("Valid Range");
        headingsList.add("Alterable After Creation");
        headingsList.add("Description");
        headingsList.add("Enumerated Literals");
        headingsList.add("Notes");
        Object[] headings = headingsList.toArray();
        for (ArtifactReadable artifact : subMessages) {
            for (ArtifactReadable struct : artifact.getRelated(CoreRelationTypes.InterfaceSubMessageContent_Structure).getList()) {
                int byteLocation = 0;
                writer.startSheet((String)structureLinks.get(struct.getName()), columnCount);
                writer.writeHeaderRow(headings);
                for (ArtifactReadable element : struct.getRelated(CoreRelationTypes.InterfaceStructureContent_DataElement).getList()) {
                    ArtifactReadable platformType = (ArtifactReadable)element.getRelated(CoreRelationTypes.InterfaceElementPlatformType_PlatformType).getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
                    Integer byteSize = Integer.valueOf(platformType.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfacePlatformTypeBitSize, "0")) / 8;
                    this.printDataElementRow(writer, branch, element, byteLocation, byteSize, platformType);
                    byteLocation += byteSize.intValue();
                }
                writer.endSheet();
            }
        }
    }

    private void printDataElementRow(ExcelXmlWriter writer, BranchId branch, ArtifactReadable artifact, Integer byteLocation, Integer byteSize, ArtifactReadable platformType) throws IOException {
        Integer beginWord = Math.floorDiv(byteLocation, 4);
        Integer beginByte = Math.floorMod(byteLocation, 4);
        Integer endWord = Math.floorDiv(byteLocation + byteSize - 1, 4);
        Integer endByte = Math.floorMod(byteLocation + byteSize - 1, 4);
        String enumLiterals = artifact.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfacePlatformTypeEnumLiteral, "");
        String elementName = (String)artifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Name);
        String dataType = platformType.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceLogicalType, "n/a");
        String units = platformType.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfacePlatformTypeUnits, "n/a");
        String validRange = platformType.getExistingAttributeTypes().contains(CoreAttributeTypes.InterfacePlatformTypeMinval) ? String.valueOf(platformType.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfacePlatformTypeMinval, "n/a")) + "-" + platformType.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfacePlatformTypeMaxval, "n/a") : platformType.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfacePlatformTypeValidRangeDescription, " ");
        String alterable = artifact.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceElementAlterable, "No");
        alterable = alterable.equalsIgnoreCase("true") ? "Yes" : "No";
        String description = artifact.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Description, "n/a");
        String notes = artifact.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Notes, " ");
        if (platformType.getExistingRelationTypes().contains(CoreRelationTypes.InterfacePlatformTypeEnumeration)) {
            enumLiterals = "";
            ArtifactReadable enumDef = (ArtifactReadable)platformType.getRelated(CoreRelationTypes.InterfacePlatformTypeEnumeration_EnumerationSet).getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
            for (ArtifactReadable enumState : enumDef.getRelated(CoreRelationTypes.InterfaceEnumeration_EnumerationState).getList()) {
                enumLiterals = String.valueOf(enumLiterals) + enumState.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceEnumOrdinal, "0") + " = " + enumState.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Name, "") + "; ";
            }
        } else {
            enumLiterals = platformType.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfacePlatformTypeEnumLiteral, " ");
        }
        if (artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.InterfaceDataElementArray})) {
            int startIndex = (Integer)artifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InterfaceElementIndexStart, (Object)0);
            int endIndex = (Integer)artifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InterfaceElementIndexEnd, (Object)0);
            int i = startIndex;
            while (i < endIndex + 1) {
                writer.writeCell((Object)beginWord);
                writer.writeCell((Object)beginByte);
                writer.writeCell((Object)byteSize);
                writer.writeCell((Object)endWord);
                writer.writeCell((Object)endByte);
                writer.writeCell((Object)dataType);
                writer.writeCell((Object)elementName.replace("[i]", Integer.toString(i)));
                writer.writeCell((Object)units);
                writer.writeCell((Object)validRange);
                writer.writeCell((Object)alterable);
                writer.writeCell((Object)description);
                writer.writeCell((Object)enumLiterals);
                writer.writeCell((Object)notes);
                byteLocation = byteLocation + byteSize;
                beginWord = Math.floorDiv(byteLocation, 8);
                beginByte = Math.floorMod(byteLocation, 8);
                endWord = Math.floorDiv(byteLocation + byteSize, 8);
                endByte = Math.floorMod(byteLocation + byteSize, 8);
                writer.endRow();
                ++i;
            }
        } else {
            writer.writeCell((Object)beginWord);
            writer.writeCell((Object)beginByte);
            writer.writeCell((Object)byteSize);
            writer.writeCell((Object)endWord);
            writer.writeCell((Object)endByte);
            writer.writeCell((Object)dataType);
            writer.writeCell((Object)elementName);
            writer.writeCell((Object)units);
            writer.writeCell((Object)validRange);
            writer.writeCell((Object)alterable);
            writer.writeCell((Object)description);
            writer.writeCell((Object)enumLiterals);
            writer.writeCell((Object)notes);
            writer.endRow();
        }
    }

    private void createMessageSubMessageSummary(ExcelXmlWriter writer, BranchId branch, ArtifactReadable connection, ArtifactReadable primaryNode, ArtifactReadable secondaryNode, List<ArtifactReadable> messages) throws IOException {
        int columnCount = 10;
        List connectionMessages = messages.stream().filter(e -> e.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageType).equals("Operational")).collect(Collectors.toList());
        List primaryList = connectionMessages.stream().filter(e -> primaryNode.equals(e.getRelated(CoreRelationTypes.InterfaceMessageSendingNode_Node).getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL))).collect(Collectors.toList());
        List secondaryList = connectionMessages.stream().filter(e -> secondaryNode.equals(e.getRelated(CoreRelationTypes.InterfaceMessageSendingNode_Node).getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL))).collect(Collectors.toList());
        writer.startSheet("Message and SubMessage Summary", columnCount);
        writer.writeCell((Object)new CellData(String.valueOf(primaryNode.getName()) + " Initiated Message", "", "4", "", "OseeBoldStyle"));
        writer.writeCell((Object)new CellData(String.valueOf(secondaryNode.getName()) + " Initiated Message", "", "4", "", "OseeBoldStyle"));
        writer.endRow();
        writer.writeCell((Object)new CellData("No.", "", "", "", "OseeBoldStyle"));
        writer.writeCell((Object)new CellData("Rate", "", "", "", "OseeBoldStyle"));
        writer.writeCell((Object)new CellData("Read/Write", "", "", "", "OseeBoldStyle"));
        writer.writeCell((Object)new CellData("Content", "", "1", "", "OseeBoldStyle"));
        writer.writeCell((Object)new CellData("No.", "", "", "", "OseeBoldStyle"));
        writer.writeCell((Object)new CellData("Rate", "", "", "", "OseeBoldStyle"));
        writer.writeCell((Object)new CellData("Read/Write", "", "", "", "OseeBoldStyle"));
        writer.writeCell((Object)new CellData("Content", "", "1", "", "OseeBoldStyle"));
        writer.endRow();
        int lastMessageNumber = 0;
        lastMessageNumber = primaryList.size() > secondaryList.size() ? primaryList.size() : secondaryList.size();
        int i = 0;
        while (i < lastMessageNumber) {
            ArtifactReadableImpl primaryMessage = ArtifactReadable.SENTINEL;
            ArtifactReadableImpl secondaryMessage = ArtifactReadable.SENTINEL;
            List primarySubMessages = new ArrayList();
            List secondarySubMessages = new ArrayList();
            try {
                primaryMessage = (ArtifactReadable)primaryList.get(i);
                primarySubMessages = primaryMessage.getRelated(CoreRelationTypes.InterfaceMessageSubMessageContent_SubMessage).getList();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            try {
                secondaryMessage = (ArtifactReadable)secondaryList.get(i);
                secondarySubMessages = secondaryMessage.getRelated(CoreRelationTypes.InterfaceMessageSubMessageContent_SubMessage).getList();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            int subMessagesCount = Math.max(primarySubMessages.size(), secondarySubMessages.size());
            String mergeDown = Integer.toString(subMessagesCount + 1);
            if (primaryMessage.isValid()) {
                writer.writeCell((Object)new CellData(primaryMessage.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageNumber), "", "", mergeDown));
                writer.writeCell((Object)new CellData(primaryMessage.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageRate, "Aperiodic"), "", "", mergeDown));
                writer.writeCell((Object)new CellData(primaryMessage.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageWriteAccess), "", "", mergeDown));
                writer.writeCell((Object)new CellData(primaryMessage.getName(), "", "1", "", "OseeBoldStyle"));
            } else {
                writer.writeCell((Object)new CellData("", "", "", mergeDown));
                writer.writeCell((Object)new CellData("", "", "", mergeDown));
                writer.writeCell((Object)new CellData("", "", "", mergeDown));
                writer.writeCell((Object)new CellData("", "", "1", ""));
            }
            if (secondaryMessage.isValid()) {
                writer.writeCell((Object)new CellData(secondaryMessage.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageNumber), "", "", mergeDown));
                writer.writeCell((Object)new CellData(secondaryMessage.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageRate, "Aperiodic"), "", "", mergeDown));
                writer.writeCell((Object)new CellData(secondaryMessage.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceMessageWriteAccess), "", "", mergeDown));
                writer.writeCell((Object)new CellData(secondaryMessage.getName(), "", "1", "", "OseeBoldStyle"));
            } else {
                writer.writeCell((Object)new CellData("", "", "", mergeDown));
                writer.writeCell((Object)new CellData("", "", "", mergeDown));
                writer.writeCell((Object)new CellData("", "", "", mergeDown));
                writer.writeCell((Object)new CellData("", "", "1", ""));
            }
            writer.endRow();
            if (primaryMessage.isValid()) {
                writer.writeCell((Object)new CellData("Sofware Interface Header", "", "1", ""), 3);
            } else {
                writer.writeCell((Object)new CellData("", "", "1", ""), 3);
            }
            if (secondaryMessage.isValid()) {
                writer.writeCell((Object)new CellData("Sofware Interface Header", "", "1", ""), 8);
            } else {
                writer.writeCell((Object)new CellData("", "", "1", ""), 8);
            }
            writer.endRow();
            int j = 0;
            while (j < subMessagesCount) {
                ArtifactReadableImpl secondarySubMessage;
                ArtifactReadableImpl primarySubMessage;
                try {
                    primarySubMessage = (ArtifactReadable)primarySubMessages.get(j);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    primarySubMessage = ArtifactReadable.SENTINEL;
                }
                try {
                    secondarySubMessage = (ArtifactReadable)secondarySubMessages.get(j);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    secondarySubMessage = ArtifactReadable.SENTINEL;
                }
                if (primarySubMessage.isValid()) {
                    writer.writeCell((Object)new CellData("Submessage " + Integer.toString(j) + ":", "", "", ""), 3);
                    writer.writeCell((Object)primarySubMessage.getName());
                }
                if (secondarySubMessage.isValid()) {
                    writer.writeCell((Object)new CellData("Submessage " + Integer.toString(j) + ":", "", "", ""), 8);
                    writer.writeCell((Object)secondarySubMessage.getName());
                }
                writer.endRow();
                ++j;
            }
            ++i;
        }
        writer.endSheet();
    }
}

