/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.config.admin.internal;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.osee.config.admin.internal.ConfigManagerConfiguration;
import org.eclipse.osee.config.admin.internal.ConfigManagerConstants;
import org.eclipse.osee.config.admin.internal.ConfigUtil;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class ConfigManagerConfigurationBuilder {
    private final ConfigManagerConfigurationImpl config = new ConfigManagerConfigurationImpl();

    private ConfigManagerConfigurationBuilder() {
    }

    public static ConfigManagerConfigurationBuilder newBuilder() {
        return new ConfigManagerConfigurationBuilder();
    }

    public ConfigManagerConfiguration build() {
        return this.config.clone();
    }

    public ConfigManagerConfigurationBuilder properties(Map<String, Object> props) {
        this.config.loadProperties(props);
        return this;
    }

    public ConfigManagerConfigurationBuilder pollTime(long pollTime, TimeUnit pollTimeUnit) {
        this.config.setPollTime(pollTime);
        this.config.setPollTimeUnit(pollTimeUnit);
        return this;
    }

    public ConfigManagerConfigurationBuilder configUri(String configUri) {
        this.config.setConfigUri(configUri);
        return this;
    }

    private static final class ConfigManagerConfigurationImpl
    implements ConfigManagerConfiguration,
    Cloneable {
        private String configUri;
        private long pollTime;
        private TimeUnit pollTimeUnit;

        private ConfigManagerConfigurationImpl() {
        }

        public synchronized ConfigManagerConfigurationImpl clone() {
            ConfigManagerConfigurationImpl cloned = new ConfigManagerConfigurationImpl();
            cloned.configUri = this.configUri;
            cloned.pollTime = this.pollTime;
            cloned.pollTimeUnit = this.pollTimeUnit;
            return cloned;
        }

        @Override
        public String getConfigUri() {
            return this.configUri;
        }

        @Override
        public long getPollTime() {
            return this.pollTime;
        }

        @Override
        public TimeUnit getTimeUnit() {
            return this.pollTimeUnit;
        }

        public void setConfigUri(String configUri) {
            this.configUri = configUri;
        }

        public void setPollTime(long pollTime) {
            this.pollTime = pollTime;
        }

        public void setPollTimeUnit(TimeUnit pollTimeUnit) {
            this.pollTimeUnit = pollTimeUnit;
        }

        public void loadProperties(Map<String, Object> props) {
            if (props != null) {
                this.setConfigUri(this.get(props, ConfigManagerConstants.CONFIGURATION_URI, ConfigUtil.getDefaultConfig()));
                this.setPollTime(this.getLong(props, ConfigManagerConstants.CONFIGURATION_POLL_TIME, 3L));
                this.setPollTimeUnit(this.getTimeUnit(props, ConfigManagerConstants.CONFIGURATION_POLL_TIME_UNIT, ConfigManagerConstants.DEFAULT_POLL_TIME_UNIT));
            }
        }

        private TimeUnit getTimeUnit(Map<String, Object> props, String pollTimeUnit, TimeUnit defaultPollTimeUnit) {
            String value = this.get(props, pollTimeUnit, defaultPollTimeUnit);
            TimeUnit toReturn = TimeUnit.SECONDS;
            TimeUnit[] timeUnitArray = TimeUnit.values();
            int n = timeUnitArray.length;
            int n2 = 0;
            while (n2 < n) {
                TimeUnit unit = timeUnitArray[n2];
                if (unit.name().equalsIgnoreCase(value)) {
                    toReturn = unit;
                    break;
                }
                ++n2;
            }
            return toReturn;
        }

        private long getLong(Map<String, Object> props, String key, Long defaultValue) {
            String toReturn = this.get(props, key, String.valueOf(defaultValue));
            return Strings.isNumeric((String)toReturn) ? Long.parseLong(toReturn) : 3L;
        }

        private String get(Map<String, Object> props, String key, Enum<?> defaultValue) {
            return this.get(props, key, defaultValue != null ? defaultValue.name() : null);
        }

        private String get(Map<String, Object> props, String key, String defaultValue) {
            String toReturn = defaultValue;
            Object object = props.get(key);
            if (object != null) {
                toReturn = String.valueOf(object);
            }
            return toReturn;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.configUri == null ? 0 : this.configUri.hashCode());
            result = 31 * result + (int)(this.pollTime ^ this.pollTime >>> 32);
            result = 31 * result + (this.pollTimeUnit == null ? 0 : this.pollTimeUnit.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConfigManagerConfigurationImpl other = (ConfigManagerConfigurationImpl)obj;
            if (this.configUri == null ? other.configUri != null : !this.configUri.equals(other.configUri)) {
                return false;
            }
            if (this.pollTime != other.pollTime) {
                return false;
            }
            return this.pollTimeUnit == other.pollTimeUnit;
        }

        public String toString() {
            return "ConfigManagerConfigurationImpl [configFile=" + this.configUri + ", pollTime=" + this.pollTime + ", pollTimeUnit=" + (Object)((Object)this.pollTimeUnit) + "]";
        }
    }
}

