/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mail.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.mail.api.MailUtils;

@XmlRootElement
public class MailMessage {
    private String id;
    private String subject;
    private String from;
    @XmlElement
    private final Collection<String> replyToAddress = new LinkedHashSet<String>();
    @XmlElement
    private final Collection<String> recepientAddresses = new LinkedHashSet<String>();
    @XmlTransient
    private final List<DataHandler> attachments = new ArrayList<DataHandler>();

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public Collection<String> getReplyTo() {
        return this.replyToAddress;
    }

    public void setReplyTo(Collection<String> replyTo) {
        this.replyToAddress.clear();
        this.replyToAddress.addAll(replyTo);
    }

    public Collection<String> getRecipients() {
        return this.recepientAddresses;
    }

    public void setRecipients(Collection<String> recipientAddress) {
        this.recepientAddresses.clear();
        this.recepientAddresses.addAll(recipientAddress);
    }

    @XmlElement
    public Collection<DataHandler> getAttachments() {
        return this.attachments;
    }

    public void addAttachment(DataSource ... dataSource) {
        DataSource[] dataSourceArray = dataSource;
        int n = dataSource.length;
        int n2 = 0;
        while (n2 < n) {
            DataSource source = dataSourceArray[n2];
            this.attachments.add(new DataHandler(source));
            ++n2;
        }
    }

    public void addAttachment(DataHandler ... dataHandler) {
        DataHandler[] dataHandlerArray = dataHandler;
        int n = dataHandler.length;
        int n2 = 0;
        while (n2 < n) {
            DataHandler handler = dataHandlerArray[n2];
            this.attachments.add(handler);
            ++n2;
        }
    }

    public static MailMessageBuilder newBuilder() {
        return new MailMessageBuilder();
    }

    public static class MailMessageBuilder {
        private String subject;
        private String from;
        private final Collection<String> replyTos = new LinkedHashSet<String>();
        private final Collection<String> recipients = new LinkedHashSet<String>();
        private final List<DataHandler> attachments = new ArrayList<DataHandler>();

        public MailMessage build() {
            MailMessage message = new MailMessage();
            message.setId(GUID.create());
            message.setFrom(this.from);
            message.setSubject(this.subject);
            message.setRecipients(this.recipients);
            message.setReplyTo(this.replyTos);
            message.getAttachments().addAll(this.attachments);
            return message;
        }

        public MailMessageBuilder from(String from) {
            this.from = from;
            return this;
        }

        public MailMessageBuilder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public MailMessageBuilder recipient(String ... recipient) {
            this.recipients(Arrays.asList(recipient));
            return this;
        }

        public MailMessageBuilder recipients(Collection<String> values) {
            this.recipients.addAll(values);
            return this;
        }

        public MailMessageBuilder replyTo(String ... replyTo) {
            this.replyTos(Arrays.asList(replyTo));
            return this;
        }

        public MailMessageBuilder replyTos(Collection<String> values) {
            this.replyTos.addAll(values);
            return this;
        }

        public MailMessageBuilder addHtml(String html) {
            String id = GUID.create();
            this.attach(MailUtils.createFromHtml(id, html));
            return this;
        }

        public MailMessageBuilder addText(String text) {
            String id = GUID.create();
            this.attach(MailUtils.createFromString(id, text, new Object[0]));
            return this;
        }

        public MailMessageBuilder addOutlookEvent(String eventName, String location, Date startDate, Date endDate) {
            this.attach(MailUtils.createOutlookEvent(eventName, location, startDate, endDate));
            return this;
        }

        public MailMessageBuilder attach(DataSource ds) {
            this.attach(new DataHandler(ds));
            return this;
        }

        public MailMessageBuilder attach(DataHandler dh) {
            this.attachments.add(dh);
            return this;
        }
    }
}

