/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.account.admin.internal;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.osee.account.admin.AccountPreferences;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.BaseId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class AccountPreferencesArtifact
extends BaseId
implements AccountPreferences,
ArtifactId {
    private final ArtifactReadable artifact;
    private Map<String, String> data = Collections.emptyMap();
    private final AtomicBoolean wasLoaded = new AtomicBoolean(false);

    public AccountPreferencesArtifact(String uuid, ArtifactReadable artifact) {
        super(artifact.getId());
        this.artifact = artifact;
    }

    public String get(String key) {
        this.checkLoaded();
        return this.data.get(key);
    }

    public boolean getBoolean(String key) {
        this.checkLoaded();
        String value = this.data.get(key);
        return Boolean.valueOf(value);
    }

    public Set<String> getKeys() {
        this.checkLoaded();
        return this.data.keySet();
    }

    public Map<String, String> asMap() {
        this.checkLoaded();
        return Collections.unmodifiableMap(this.data);
    }

    private void checkLoaded() {
        String settings;
        if (this.wasLoaded.compareAndSet(false, true) && (settings = (String)this.artifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.UserSettings, null)) != null) {
            PropertyStore storage = new PropertyStore(this.artifact.getGuid());
            try {
                storage.load((Reader)new StringReader(settings));
            }
            catch (Exception ex) {
                throw OseeCoreException.wrap((Throwable)ex);
            }
            HashMap<String, String> map = new HashMap<String, String>();
            for (String key : storage.keySet()) {
                map.put(key, storage.get(key));
            }
            this.data = map;
        }
    }
}

