/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.InterfaceElementApi;
import org.eclipse.osee.mim.InterfaceElementArrayApi;
import org.eclipse.osee.mim.InterfacePlatformTypeApi;
import org.eclipse.osee.mim.InterfaceStructureApi;
import org.eclipse.osee.mim.InterfaceStructureEndpoint;
import org.eclipse.osee.mim.types.InterfaceStructureElementToken;
import org.eclipse.osee.mim.types.InterfaceStructureToken;
import org.eclipse.osee.mim.types.PlatformTypeToken;

public class InterfaceStructureEndpointImpl
implements InterfaceStructureEndpoint {
    private final BranchId branch;
    private final UserId account;
    private final ArtifactId messageId;
    private final ArtifactId subMessageId;
    private final InterfaceStructureApi interfaceStructureApi;
    private final InterfaceElementApi interfaceElementApi;
    private final InterfaceElementArrayApi interfaceElementArrayApi;
    private final InterfacePlatformTypeApi platformApi;

    public InterfaceStructureEndpointImpl(BranchId branch, UserId accountId, ArtifactId messageId, ArtifactId subMessageId, InterfaceStructureApi interfaceStructureApi, InterfaceElementApi interfaceElementApi, InterfaceElementArrayApi interfaceElementArrayApi, InterfacePlatformTypeApi interfacePlatformTypeApi) {
        this.account = accountId;
        this.branch = branch;
        this.messageId = messageId;
        this.subMessageId = subMessageId;
        this.interfaceStructureApi = interfaceStructureApi;
        this.interfaceElementApi = interfaceElementApi;
        this.interfaceElementArrayApi = interfaceElementArrayApi;
        this.platformApi = interfacePlatformTypeApi;
    }

    @Override
    public Collection<InterfaceStructureToken> getAllStructures() {
        try {
            List structureList = (List)this.interfaceStructureApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceSubMessageContent_SubMessage, this.subMessageId, InterfaceStructureToken.class);
            for (InterfaceStructureToken structure : structureList) {
                double beginWord = 0.0;
                double endWord = 0.0;
                double beginWordDisplay = 0.0;
                double endWordDisplay = 0.0;
                double beginByte = 0.0;
                double endByte = 0.0;
                double beginByteDisplay = 0.0;
                double endByteDisplay = 0.0;
                double sizeInBytes = 0.0;
                LinkedList<InterfaceStructureElementToken> elements = new LinkedList<InterfaceStructureElementToken>();
                elements.addAll(this.interfaceElementApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceStructureContent_Structure, ArtifactId.valueOf((Long)structure.getId()), InterfaceStructureElementToken.class));
                for (InterfaceStructureElementToken element : elements) {
                    PlatformTypeToken platformType = this.platformApi.getAccessor().getByRelationWithoutId(this.branch, CoreRelationTypes.InterfaceElementPlatformType_Element, ArtifactId.valueOf((Long)element.getId()), PlatformTypeToken.class);
                    sizeInBytes += Double.parseDouble(platformType.getInterfacePlatformTypeBitSize()) / 8.0 * (double)Math.max(1, element.getInterfaceElementIndexEnd() - element.getInterfaceElementIndexStart());
                    endByte = beginByte + (Double.parseDouble(platformType.getInterfacePlatformTypeBitSize()) / 8.0 - 1.0) * (double)Math.max(1, element.getInterfaceElementIndexEnd() - element.getInterfaceElementIndexStart()) % 4.0;
                    endWord = beginWord + (Double.parseDouble(platformType.getInterfacePlatformTypeBitSize()) / 8.0 - 1.0) * (double)Math.max(1, element.getInterfaceElementIndexEnd() - element.getInterfaceElementIndexStart()) / 4.0;
                    beginByteDisplay = Math.floor(beginByte);
                    endByteDisplay = Math.floor(endByte);
                    element.setBeginByte(beginByteDisplay);
                    element.setEndByte(endByteDisplay);
                    beginByte = (endByte + 1.0) % 4.0;
                    beginWordDisplay = Math.floor(beginWord);
                    endWordDisplay = Math.floor(endWord);
                    element.setBeginWord(beginWordDisplay);
                    element.setEndWord(endWordDisplay);
                    beginWord += Double.parseDouble(platformType.getInterfacePlatformTypeBitSize()) / 8.0 * (double)Math.max(1, element.getInterfaceElementIndexEnd() - element.getInterfaceElementIndexStart()) / 4.0;
                    element.setPlatformTypeId(platformType.getId());
                    element.setPlatformTypeName(platformType.getName());
                }
                structure.setSizeInBytes(sizeInBytes);
                structure.setElements(elements);
            }
            return structureList;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return null;
        }
    }

    @Override
    public InterfaceStructureToken getStructure(ArtifactId structureId) {
        try {
            return this.interfaceStructureApi.getAccessor().getByRelation(this.branch, structureId, CoreRelationTypes.InterfaceSubMessageContent_SubMessage, this.subMessageId, InterfaceStructureToken.class);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return null;
        }
    }
}

