/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.adaptor.StatusException;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.MultiSourcePackage;
import org.eclipse.osgi.framework.internal.core.NullPackageSource;
import org.eclipse.osgi.framework.internal.core.PackageSource;
import org.eclipse.osgi.framework.internal.core.PolicyHandler;
import org.eclipse.osgi.framework.internal.core.SingleSourcePackage;
import org.eclipse.osgi.framework.internal.core.SystemBundleLoader;
import org.eclipse.osgi.framework.util.KeyedHashSet;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class BundleLoader
implements ClassLoaderDelegate {
    public static final String DEFAULT_PACKAGE = ".";
    public static final String JAVA_PACKAGE = "java.";
    public static final byte FLAG_IMPORTSINIT = 1;
    public static final byte FLAG_HASDYNAMICIMPORTS = 2;
    public static final byte FLAG_HASDYNAMICEIMPORTALL = 4;
    public static final byte FLAG_CLOSED = 8;
    public static final ClassContext CLASS_CONTEXT = (ClassContext)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return new ClassContext();
        }
    });
    public static final ClassLoader FW_CLASSLOADER;
    private static final boolean USE_GLOBAL_DEADLOCK_AVOIDANCE_LOCK;
    private static final List waitingList;
    private static Object lockThread;
    private static int lockCount;
    private final BundleLoaderProxy proxy;
    final BundleHost bundle;
    private final PolicyHandler policy;
    private final Collection exportedPackages;
    final BundleLoaderProxy[] requiredBundles;
    final int[] reexportTable;
    private final KeyedHashSet requiredSources;
    private KeyedHashSet importedSources;
    private String[] dynamicImportPackageStems;
    private String[] dynamicImportPackages;
    private byte loaderFlags = 0;
    private BundleClassLoader classloader;
    private ClassLoader parent;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.framework.internal.core.Framework");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        FW_CLASSLOADER = BundleLoader.getClassLoader(clazz);
        USE_GLOBAL_DEADLOCK_AVOIDANCE_LOCK = "true".equals(FrameworkProperties.getProperty("osgi.classloader.singleThreadLoads"));
        waitingList = USE_GLOBAL_DEADLOCK_AVOIDANCE_LOCK ? new ArrayList(0) : null;
        lockCount = 0;
    }

    public static final String getPackageName(String name) {
        int index;
        if (name != null && (index = name.lastIndexOf(46)) > 0) {
            return name.substring(0, index);
        }
        return DEFAULT_PACKAGE;
    }

    public static final String getResourcePackageName(String name) {
        if (name != null) {
            int begin = name.length() > 1 && name.charAt(0) == '/' ? 1 : 0;
            int end = name.lastIndexOf(47);
            if (end > begin) {
                return name.substring(begin, end).replace('/', '.');
            }
        }
        return DEFAULT_PACKAGE;
    }

    protected BundleLoader(BundleHost bundle, BundleLoaderProxy proxy) throws BundleException {
        this.bundle = bundle;
        this.proxy = proxy;
        try {
            bundle.getBundleData().open();
        }
        catch (IOException e) {
            throw new BundleException(Msg.BUNDLE_READ_EXCEPTION, e);
        }
        BundleDescription description = proxy.getBundleDescription();
        BundleDescription[] required = description.getResolvedRequires();
        if (required.length > 0) {
            HashSet<String> reExportSet = new HashSet<String>(required.length);
            BundleSpecification[] requiredSpecs = description.getRequiredBundles();
            if (requiredSpecs != null && requiredSpecs.length > 0) {
                int i = 0;
                while (i < requiredSpecs.length) {
                    if (requiredSpecs[i].isExported()) {
                        reExportSet.add(requiredSpecs[i].getName());
                    }
                    ++i;
                }
            }
            this.requiredBundles = new BundleLoaderProxy[required.length];
            int[] reexported = new int[required.length];
            int reexportIndex = 0;
            int i = 0;
            while (i < required.length) {
                this.requiredBundles[i] = this.getLoaderProxy(required[i]);
                if (reExportSet.contains(required[i].getSymbolicName())) {
                    reexported[reexportIndex++] = i;
                }
                ++i;
            }
            if (reexportIndex > 0) {
                this.reexportTable = new int[reexportIndex];
                System.arraycopy(reexported, 0, this.reexportTable, 0, reexportIndex);
            } else {
                this.reexportTable = null;
            }
            this.requiredSources = new KeyedHashSet(10, false);
        } else {
            this.requiredBundles = null;
            this.reexportTable = null;
            this.requiredSources = null;
        }
        ExportPackageDescription[] exports = description.getSelectedExports();
        if (exports != null && exports.length > 0) {
            this.exportedPackages = exports.length > 10 ? new HashSet(exports.length) : new ArrayList(exports.length);
            int i = 0;
            while (i < exports.length) {
                if (proxy.forceSourceCreation(exports[i]) && !this.exportedPackages.contains(exports[i].getName())) {
                    proxy.createPackageSource(exports[i], true);
                }
                this.exportedPackages.add(exports[i].getName());
                ++i;
            }
        } else {
            this.exportedPackages = null;
        }
        Bundle[] fragmentObjects = bundle.getFragments();
        BundleDescription[] fragments = new BundleDescription[fragmentObjects == null ? 0 : fragmentObjects.length];
        int i = 0;
        while (i < fragments.length) {
            fragments[i] = ((AbstractBundle)fragmentObjects[i]).getBundleDescription();
            ++i;
        }
        if (description.hasDynamicImports()) {
            this.addDynamicImportPackage(description.getImportPackages());
        }
        i = 0;
        while (i < fragments.length) {
            if (fragments[i].isResolved() && fragments[i].hasDynamicImports()) {
                this.addDynamicImportPackage(fragments[i].getImportPackages());
            }
            ++i;
        }
        String buddyList = null;
        try {
            buddyList = (String)bundle.getBundleData().getManifest().get("Eclipse-BuddyPolicy");
        }
        catch (BundleException bundleException) {}
        this.policy = buddyList != null ? new PolicyHandler(this, buddyList) : null;
    }

    private synchronized KeyedHashSet getImportedSources() {
        if ((this.loaderFlags & 1) != 0) {
            return this.importedSources;
        }
        ExportPackageDescription[] packages = this.proxy.getBundleDescription().getResolvedImports();
        if (packages != null && packages.length > 0) {
            if (this.importedSources == null) {
                this.importedSources = new KeyedHashSet(packages.length, false);
            }
            int i = 0;
            while (i < packages.length) {
                PackageSource source = this.createExportPackageSource(packages[i]);
                if (source != null) {
                    this.importedSources.add(source);
                }
                ++i;
            }
        }
        this.loaderFlags = (byte)(this.loaderFlags | 1);
        return this.importedSources;
    }

    final PackageSource createExportPackageSource(ExportPackageDescription export) {
        BundleLoaderProxy exportProxy = this.getLoaderProxy(export.getExporter());
        if (exportProxy == null) {
            return null;
        }
        PackageSource requiredSource = exportProxy.getBundleLoader().findRequiredSource(export.getName());
        PackageSource exportSource = exportProxy.createPackageSource(export, false);
        if (requiredSource == null) {
            return exportSource;
        }
        return BundleLoader.createMultiSource(export.getName(), new PackageSource[]{requiredSource, exportSource});
    }

    private static PackageSource createMultiSource(String packageName, PackageSource[] sources) {
        if (sources.length == 1) {
            return sources[0];
        }
        ArrayList<SingleSourcePackage> sourceList = new ArrayList<SingleSourcePackage>(sources.length);
        int i = 0;
        while (i < sources.length) {
            SingleSourcePackage[] innerSources = sources[i].getSuppliers();
            int j = 0;
            while (j < innerSources.length) {
                if (!sourceList.contains(innerSources[j])) {
                    sourceList.add(innerSources[j]);
                }
                ++j;
            }
            ++i;
        }
        return new MultiSourcePackage(packageName, sourceList.toArray(new SingleSourcePackage[sourceList.size()]));
    }

    final BundleLoaderProxy getLoaderProxy(BundleDescription source) {
        BundleLoaderProxy sourceProxy = (BundleLoaderProxy)source.getUserObject();
        if (sourceProxy == null) {
            long exportingID = source.getBundleId();
            BundleHost exportingBundle = (BundleHost)this.bundle.framework.getBundle(exportingID);
            if (exportingBundle == null) {
                return null;
            }
            sourceProxy = exportingBundle.getLoaderProxy();
        }
        return sourceProxy;
    }

    synchronized void close() {
        if ((this.loaderFlags & 8) != 0) {
            return;
        }
        if (this.classloader != null) {
            this.classloader.close();
        }
        if (this.policy != null) {
            this.policy.close();
        }
        this.loaderFlags = (byte)(this.loaderFlags | 8);
    }

    final Class loadClass(String name) throws ClassNotFoundException {
        return this.createClassLoader().loadClass(name);
    }

    final URL getResource(String name) {
        return this.createClassLoader().getResource(name);
    }

    final synchronized ClassLoader getParentClassLoader() {
        if (this.parent != null) {
            return this.parent;
        }
        this.createClassLoader();
        return this.parent;
    }

    final synchronized BundleClassLoader createClassLoader() {
        String[] classpath;
        if (this.classloader != null) {
            return this.classloader;
        }
        try {
            classpath = this.bundle.getBundleData().getClassPath();
        }
        catch (BundleException e) {
            classpath = new String[]{};
            this.bundle.framework.publishFrameworkEvent(2, this.bundle, e);
        }
        if (classpath == null) {
            classpath = new String[]{};
            this.bundle.framework.publishFrameworkEvent(2, this.bundle, new BundleException(Msg.BUNDLE_NO_CLASSPATH_MATCH));
        }
        BundleClassLoader bcl = this.createBCLPrevileged(this.bundle.getProtectionDomain(), classpath);
        this.parent = this.getParentPrivileged(bcl);
        this.classloader = bcl;
        return this.classloader;
    }

    Class findLocalClass(String name) throws ClassNotFoundException {
        if (Debug.DEBUG_LOADER) {
            Debug.println("BundleLoader[" + this + "].findLocalClass(" + name + ")");
        }
        try {
            Class clazz = this.createClassLoader().findLocalClass(name);
            if (Debug.DEBUG_LOADER && clazz != null) {
                Debug.println("BundleLoader[" + this + "] found local class " + name);
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            if (e instanceof StatusException && (((StatusException)((Object)e)).getStatusCode() & 8) != 0) {
                throw e;
            }
            return null;
        }
    }

    public Class findClass(String name) throws ClassNotFoundException {
        return this.findClass(name, true);
    }

    Class findClass(String name, boolean checkParent) throws ClassNotFoundException {
        ClassLoader parentCL = this.getParentClassLoader();
        if (checkParent && parentCL != null && name.startsWith(JAVA_PACKAGE)) {
            return parentCL.loadClass(name);
        }
        try {
            if (USE_GLOBAL_DEADLOCK_AVOIDANCE_LOCK) {
                BundleLoader.lock(this.createClassLoader());
            }
            Class clazz = this.findClassInternal(name, checkParent, parentCL);
            return clazz;
        }
        finally {
            if (USE_GLOBAL_DEADLOCK_AVOIDANCE_LOCK) {
                BundleLoader.unlock();
            }
        }
    }

    private Class findClassInternal(String name, boolean checkParent, ClassLoader parentCL) throws ClassNotFoundException {
        if (Debug.DEBUG_LOADER) {
            Debug.println("BundleLoader[" + this + "].loadBundleClass(" + name + ")");
        }
        String pkgName = BundleLoader.getPackageName(name);
        boolean bootDelegation = false;
        if (checkParent && parentCL != null && this.isBootDelegationPackage(pkgName)) {
            try {
                return parentCL.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                bootDelegation = true;
            }
        }
        Class result = null;
        PackageSource source = this.findImportedSource(pkgName);
        if (source != null) {
            result = source.loadClass(name);
            if (result != null) {
                return result;
            }
            throw new ClassNotFoundException(name);
        }
        source = this.findRequiredSource(pkgName);
        if (source != null) {
            result = source.loadClass(name);
        }
        if (result == null) {
            result = this.findLocalClass(name);
        }
        if (result != null) {
            return result;
        }
        if (source == null && (source = this.findDynamicSource(pkgName)) != null) {
            result = source.loadClass(name);
            if (result != null) {
                return result;
            }
            throw new ClassNotFoundException(name);
        }
        if (result == null && this.policy != null) {
            result = this.policy.doBuddyClassLoading(name);
        }
        if (result != null) {
            return result;
        }
        if (parentCL != null && !bootDelegation && (checkParent && this.bundle.framework.compatibiltyBootDelegation || this.isRequestFromVM())) {
            try {
                return parentCL.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        throw new ClassNotFoundException(name);
    }

    private boolean isRequestFromVM() {
        if (this.bundle.framework.bootDelegateAll || !this.bundle.framework.contextBootDelegation) {
            return false;
        }
        Class[] context = CLASS_CONTEXT.getClassContext();
        if (context == null || context.length < 2) {
            return false;
        }
        int i = 1;
        while (i < context.length) {
            Class clazz = context[i];
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.osgi.framework.internal.core.BundleLoader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz != clazz2) {
                ClassLoader cl;
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = Class.forName("java.lang.ClassLoader");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz3.isAssignableFrom(context[i]) && (cl = BundleLoader.getClassLoader(context[i])) != FW_CLASSLOADER) {
                    Class<?> clazz4 = class$3;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$3 = Class.forName("java.lang.Class");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz4 == context[i] || cl instanceof BundleClassLoader) break;
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private static ClassLoader getClassLoader(final Class clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getClassLoader();
            }
        });
    }

    public URL findResource(String name) {
        return this.findResource(name, true);
    }

    URL findResource(String name, boolean checkParent) {
        URL result;
        if (name.length() > 1 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        String pkgName = BundleLoader.getResourcePackageName(name);
        boolean bootDelegation = false;
        ClassLoader parentCL = this.getParentClassLoader();
        if (checkParent && parentCL != null) {
            if (pkgName.startsWith(JAVA_PACKAGE)) {
                return parentCL.getResource(name);
            }
            if (this.isBootDelegationPackage(pkgName)) {
                result = parentCL.getResource(name);
                if (result != null) {
                    return result;
                }
                bootDelegation = true;
            }
        }
        result = null;
        PackageSource source = this.findImportedSource(pkgName);
        if (source != null) {
            return source.getResource(name);
        }
        source = this.findRequiredSource(pkgName);
        if (source != null) {
            result = source.getResource(name);
        }
        if (result == null) {
            result = this.findLocalResource(name);
        }
        if (result != null) {
            return result;
        }
        if (source == null && (source = this.findDynamicSource(pkgName)) != null) {
            return source.getResource(name);
        }
        if (result == null && this.policy != null) {
            result = this.policy.doBuddyResourceLoading(name);
        }
        if (result != null) {
            return result;
        }
        if (parentCL != null && !bootDelegation && (checkParent && this.bundle.framework.compatibiltyBootDelegation || this.isRequestFromVM())) {
            return parentCL.getResource(name);
        }
        return result;
    }

    boolean isBootDelegationPackage(String name) {
        int i;
        if (this.bundle.framework.bootDelegateAll) {
            return true;
        }
        if (this.bundle.framework.bootDelegation != null) {
            i = 0;
            while (i < this.bundle.framework.bootDelegation.length) {
                if (name.equals(this.bundle.framework.bootDelegation[i])) {
                    return true;
                }
                ++i;
            }
        }
        if (this.bundle.framework.bootDelegationStems != null) {
            i = 0;
            while (i < this.bundle.framework.bootDelegationStems.length) {
                if (name.startsWith(this.bundle.framework.bootDelegationStems[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public Enumeration findResources(String name) throws IOException {
        Enumeration localResults;
        if (name.length() > 1 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        String pkgName = BundleLoader.getResourcePackageName(name);
        Enumeration result = null;
        PackageSource source = this.findImportedSource(pkgName);
        if (source != null) {
            return source.getResources(name);
        }
        source = this.findRequiredSource(pkgName);
        if (source != null) {
            result = source.getResources(name);
        }
        if ((result = BundleLoader.compoundEnumerations(result, localResults = this.findLocalResources(name))) == null && source == null && (source = this.findDynamicSource(pkgName)) != null) {
            return source.getResources(name);
        }
        if (this.policy != null) {
            Enumeration buddyResult = this.policy.doBuddyResourcesLoading(name);
            result = BundleLoader.compoundEnumerations(result, buddyResult);
        }
        return result;
    }

    Enumeration getResources(String name) throws IOException {
        if (name.length() > 1 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        String pkgName = BundleLoader.getResourcePackageName(name);
        Enumeration<URL> result = null;
        if (pkgName.startsWith(JAVA_PACKAGE) || this.isBootDelegationPackage(pkgName)) {
            ClassLoader parentCL = this.getParentClassLoader();
            Enumeration<URL> enumeration = result = parentCL == null ? null : parentCL.getResources(name);
            if (pkgName.startsWith(JAVA_PACKAGE)) {
                return result;
            }
        }
        return BundleLoader.compoundEnumerations(result, this.findResources(name));
    }

    static Enumeration compoundEnumerations(Enumeration list1, Enumeration list2) {
        if (list2 == null || !list2.hasMoreElements()) {
            return list1;
        }
        if (list1 == null || !list1.hasMoreElements()) {
            return list2;
        }
        Vector compoundResults = new Vector();
        while (list1.hasMoreElements()) {
            compoundResults.add(list1.nextElement());
        }
        while (list2.hasMoreElements()) {
            Object item = list2.nextElement();
            if (compoundResults.contains(item)) continue;
            compoundResults.add(item);
        }
        return compoundResults.elements();
    }

    URL findLocalResource(String name) {
        return this.createClassLoader().findLocalResource(name);
    }

    Enumeration findLocalResources(String name) {
        return this.createClassLoader().findLocalResources(name);
    }

    public String findLibrary(final String name) {
        if (System.getSecurityManager() == null) {
            return this.findLocalLibrary(name);
        }
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return BundleLoader.this.findLocalLibrary(name);
            }
        });
    }

    final String findLocalLibrary(String name) {
        String result = this.bundle.getBundleData().findLibrary(name);
        if (result != null) {
            return result;
        }
        Bundle[] fragments = this.bundle.getFragments();
        if (fragments == null || fragments.length == 0) {
            return null;
        }
        int i = 0;
        while (i < fragments.length) {
            result = ((AbstractBundle)fragments[i]).getBundleData().findLibrary(name);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return result;
    }

    final AbstractBundle getBundle() {
        return this.bundle;
    }

    private BundleClassLoader createBCLPrevileged(final BundleProtectionDomain pd, final String[] cp) {
        if (System.getSecurityManager() == null) {
            return this.createBCL(pd, cp);
        }
        return (BundleClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return BundleLoader.this.createBCL(pd, cp);
            }
        });
    }

    BundleClassLoader createBCL(BundleProtectionDomain pd, String[] cp) {
        BundleClassLoader bcl = this.bundle.getBundleData().createClassLoader(this, pd, cp);
        Bundle[] fragments = this.bundle.getFragments();
        if (fragments != null) {
            int i = 0;
            while (i < fragments.length) {
                AbstractBundle fragment = (AbstractBundle)fragments[i];
                try {
                    bcl.attachFragment(fragment.getBundleData(), fragment.domain, fragment.getBundleData().getClassPath());
                }
                catch (BundleException be) {
                    this.bundle.framework.publishFrameworkEvent(2, this.bundle, be);
                }
                ++i;
            }
        }
        bcl.initialize();
        return bcl;
    }

    public final String toString() {
        BundleData result = this.bundle.getBundleData();
        return result == null ? "BundleLoader.bundledata == null!" : result.toString();
    }

    private final synchronized boolean isDynamicallyImported(String pkgname) {
        int i;
        if (this instanceof SystemBundleLoader) {
            return false;
        }
        if (pkgname.startsWith(JAVA_PACKAGE)) {
            return true;
        }
        if ((this.loaderFlags & 2) == 0) {
            return false;
        }
        if ((this.loaderFlags & 4) != 0) {
            return true;
        }
        if (this.dynamicImportPackages != null) {
            i = 0;
            while (i < this.dynamicImportPackages.length) {
                if (pkgname.equals(this.dynamicImportPackages[i])) {
                    return true;
                }
                ++i;
            }
        }
        if (this.dynamicImportPackageStems != null) {
            i = 0;
            while (i < this.dynamicImportPackageStems.length) {
                if (pkgname.startsWith(this.dynamicImportPackageStems[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    final void addExportedProvidersFor(String symbolicName, String packageName, ArrayList result, KeyedHashSet visited) {
        if (!visited.add(this.bundle)) {
            return;
        }
        PackageSource local = null;
        if (this.isExportedPackage(packageName)) {
            local = this.proxy.getPackageSource(packageName);
        }
        if (this.requiredBundles != null) {
            int size = this.reexportTable == null ? 0 : this.reexportTable.length;
            int reexportIndex = 0;
            int i = 0;
            while (i < this.requiredBundles.length) {
                if (local != null) {
                    this.requiredBundles[i].getBundleLoader().addExportedProvidersFor(symbolicName, packageName, result, visited);
                } else if (reexportIndex < size && this.reexportTable[reexportIndex] == i) {
                    ++reexportIndex;
                    this.requiredBundles[i].getBundleLoader().addExportedProvidersFor(symbolicName, packageName, result, visited);
                }
                ++i;
            }
        }
        if (local != null && local.isFriend(symbolicName)) {
            if (local instanceof BundleLoaderProxy.ReexportPackageSource) {
                local = new SingleSourcePackage(packageName, this.proxy);
            }
            result.add(local);
        }
    }

    final boolean isExportedPackage(String name) {
        return this.exportedPackages == null ? false : this.exportedPackages.contains(name);
    }

    private void addDynamicImportPackage(ImportPackageSpecification[] packages) {
        if (packages == null) {
            return;
        }
        ArrayList<String> dynamicImports = new ArrayList<String>(packages.length);
        int i = 0;
        while (i < packages.length) {
            if ("dynamic".equals(packages[i].getDirective("resolution"))) {
                dynamicImports.add(packages[i].getName());
            }
            ++i;
        }
        if (dynamicImports.size() > 0) {
            this.addDynamicImportPackage(dynamicImports.toArray(new String[dynamicImports.size()]));
        }
    }

    private void addDynamicImportPackage(String[] packages) {
        int i;
        ArrayList<String> names;
        ArrayList<String> stems;
        if (packages == null) {
            return;
        }
        this.loaderFlags = (byte)(this.loaderFlags | 2);
        int size = packages.length;
        if (this.dynamicImportPackageStems == null) {
            stems = new ArrayList<String>(size);
        } else {
            stems = new ArrayList(size + this.dynamicImportPackageStems.length);
            int i2 = 0;
            while (i2 < this.dynamicImportPackageStems.length) {
                stems.add(this.dynamicImportPackageStems[i2]);
                ++i2;
            }
        }
        if (this.dynamicImportPackages == null) {
            names = new ArrayList<String>(size);
        } else {
            names = new ArrayList(size + this.dynamicImportPackages.length);
            i = 0;
            while (i < this.dynamicImportPackages.length) {
                names.add(this.dynamicImportPackages[i]);
                ++i;
            }
        }
        i = 0;
        while (i < size) {
            String name = packages[i];
            if (!this.isDynamicallyImported(name)) {
                if (name.equals("*")) {
                    this.loaderFlags = (byte)(this.loaderFlags | 4);
                    return;
                }
                if (name.endsWith(".*")) {
                    stems.add(name.substring(0, name.length() - 1));
                } else {
                    names.add(name);
                }
            }
            ++i;
        }
        size = stems.size();
        if (size > 0) {
            this.dynamicImportPackageStems = stems.toArray(new String[size]);
        }
        if ((size = names.size()) > 0) {
            this.dynamicImportPackages = names.toArray(new String[size]);
        }
    }

    public final synchronized void addDynamicImportPackage(ManifestElement[] packages) {
        if (packages == null) {
            return;
        }
        ArrayList<String> dynamicImports = new ArrayList<String>(packages.length);
        int i = 0;
        while (i < packages.length) {
            dynamicImports.add(packages[i].getValue());
            ++i;
        }
        if (dynamicImports.size() > 0) {
            this.addDynamicImportPackage(dynamicImports.toArray(new String[dynamicImports.size()]));
        }
    }

    synchronized void attachFragment(BundleFragment fragment) throws BundleException {
        if (this.classloader == null) {
            return;
        }
        String[] classpath = fragment.getBundleData().getClassPath();
        if (classpath != null) {
            this.classloader.attachFragment(fragment.getBundleData(), fragment.domain, classpath);
        }
    }

    private PackageSource findSource(String pkgName) {
        if (pkgName == null) {
            return null;
        }
        PackageSource result = this.findImportedSource(pkgName);
        if (result != null) {
            return result;
        }
        return this.findRequiredSource(pkgName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageSource findImportedSource(String pkgName) {
        KeyedHashSet imports = this.getImportedSources();
        if (imports == null) {
            return null;
        }
        KeyedHashSet keyedHashSet = imports;
        synchronized (keyedHashSet) {
            return (PackageSource)imports.getByKey(pkgName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageSource findDynamicSource(String pkgName) {
        ExportPackageDescription exportPackage;
        if (this.isDynamicallyImported(pkgName) && (exportPackage = this.bundle.framework.adaptor.getState().linkDynamicImport(this.proxy.getBundleDescription(), pkgName)) != null) {
            PackageSource source = this.createExportPackageSource(exportPackage);
            Object object = this;
            synchronized (object) {
                if (this.importedSources == null) {
                    this.importedSources = new KeyedHashSet(false);
                }
            }
            object = this.importedSources;
            synchronized (object) {
                this.importedSources.add(source);
            }
            return source;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageSource findRequiredSource(String pkgName) {
        PackageSource source;
        Object result;
        if (this.requiredBundles == null) {
            return null;
        }
        KeyedHashSet keyedHashSet = this.requiredSources;
        synchronized (keyedHashSet) {
            result = (PackageSource)this.requiredSources.getByKey(pkgName);
            if (result != null) {
                return ((PackageSource)result).isNullSource() ? null : result;
            }
        }
        KeyedHashSet visited = new KeyedHashSet(false);
        visited.add(this.bundle);
        result = new ArrayList(3);
        int i = 0;
        while (i < this.requiredBundles.length) {
            BundleLoader requiredLoader = this.requiredBundles[i].getBundleLoader();
            requiredLoader.addExportedProvidersFor(this.proxy.getSymbolicName(), pkgName, (ArrayList)result, visited);
            ++i;
        }
        if (((ArrayList)result).size() == 0) {
            source = NullPackageSource.getNullPackageSource(pkgName);
        } else if (((ArrayList)result).size() == 1) {
            source = (PackageSource)((ArrayList)result).get(0);
        } else {
            PackageSource[] srcs = ((ArrayList)result).toArray(new PackageSource[((ArrayList)result).size()]);
            source = BundleLoader.createMultiSource(pkgName, srcs);
        }
        KeyedHashSet keyedHashSet2 = this.requiredSources;
        synchronized (keyedHashSet2) {
            this.requiredSources.add(source);
        }
        return source.isNullSource() ? null : source;
    }

    final PackageSource getPackageSource(String pkgName) {
        PackageSource result = this.findSource(pkgName);
        if (!this.isExportedPackage(pkgName)) {
            return result;
        }
        PackageSource localSource = this.proxy.getPackageSource(pkgName);
        if (localSource instanceof BundleLoaderProxy.ReexportPackageSource) {
            localSource = new SingleSourcePackage(pkgName, this.proxy);
        }
        if (result == null) {
            return localSource;
        }
        if (localSource == null) {
            return result;
        }
        return BundleLoader.createMultiSource(pkgName, new PackageSource[]{result, localSource});
    }

    private ClassLoader getParentPrivileged(final BundleClassLoader bcl) {
        if (System.getSecurityManager() == null) {
            return bcl.getParent();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return bcl.getParent();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void lock(Object loader) {
        Thread currentThread = Thread.currentThread();
        boolean interrupted = false;
        Object object = loader;
        synchronized (object) {
            if (BundleLoader.tryLock(currentThread, loader)) {
                return;
            }
            do {
                try {
                    loader.wait();
                }
                catch (InterruptedException interruptedException) {
                    interrupted = true;
                }
            } while (!BundleLoader.tryLock(currentThread));
        }
        if (interrupted) {
            currentThread.interrupt();
        }
    }

    private static synchronized boolean tryLock(Thread currentThread, Object loader) {
        if (lockThread == currentThread) {
            ++lockCount;
            return true;
        }
        if (lockThread == null) {
            ++lockCount;
            lockThread = currentThread;
            return true;
        }
        waitingList.add(new Object[]{currentThread, loader});
        return false;
    }

    private static synchronized boolean tryLock(Thread currentThread) {
        if (lockThread == currentThread) {
            ++lockCount;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unlock() {
        Thread waitingThread = null;
        Object loader = null;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.osgi.framework.internal.core.BundleLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object object = clazz;
        synchronized (clazz) {
            if (--lockCount != 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (waitingList.isEmpty()) {
                lockThread = null;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            Object[] waiting = (Object[])waitingList.get(0);
            waitingThread = (Thread)waiting[0];
            loader = waiting[1];
            // ** MonitorExit[var2_2] (shouldn't be in output)
            object = loader;
            synchronized (object) {
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.osgi.framework.internal.core.BundleLoader");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Class<?> clazz3 = clazz2;
                synchronized (clazz2) {
                    lockThread = waitingThread;
                    waitingList.remove(0);
                    loader.notifyAll();
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                }
            }
            return;
        }
    }

    static final class ClassContext
    extends SecurityManager {
        ClassContext() {
        }

        public Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

