/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.prov.engine;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.prov.core.helpers.MultiStatus;
import org.eclipse.equinox.prov.engine.EngineSession;
import org.eclipse.equinox.prov.engine.Operand;
import org.eclipse.equinox.prov.engine.Phase;
import org.eclipse.equinox.prov.engine.Profile;

public abstract class PhaseSet {
    private final Phase[] phases;

    public PhaseSet(Phase[] phases) {
        if (phases == null) {
            throw new IllegalArgumentException("Phases must not be null");
        }
        this.phases = phases;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MultiStatus perform(EngineSession session, Profile profile, Operand[] deltas, IProgressMonitor monitor) {
        SubMonitor pm;
        MultiStatus result;
        block8: {
            MultiStatus multiStatus;
            block7: {
                MultiStatus multiStatus2;
                block6: {
                    result = new MultiStatus();
                    int[] weights = this.getProgressWeights();
                    int totalWork = this.getTotalWork(weights);
                    pm = SubMonitor.convert((IProgressMonitor)monitor, (int)totalWork);
                    try {
                        int i = 0;
                        while (i < this.phases.length) {
                            if (pm.isCanceled()) {
                                result.setCanceled();
                                multiStatus2 = result;
                                Object var11_13 = null;
                                break block6;
                            }
                            Phase phase = this.phases[i];
                            result.add((IStatus)phase.perform(session, profile, deltas, (IProgressMonitor)pm.newChild(weights[i])));
                            if (result.isErrorOrCancel()) {
                                multiStatus = result;
                                break block7;
                            }
                            ++i;
                        }
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var11_15 = null;
                        pm.done();
                        throw throwable;
                    }
                }
                pm.done();
                return multiStatus2;
            }
            Object var11_14 = null;
            pm.done();
            return multiStatus;
        }
        Object var11_16 = null;
        pm.done();
        return result;
    }

    private int getTotalWork(int[] weights) {
        int sum = 0;
        int i = 0;
        while (i < weights.length) {
            sum += weights[i];
            ++i;
        }
        return sum;
    }

    private int[] getProgressWeights() {
        int[] weights = new int[this.phases.length];
        int i = 0;
        while (i < this.phases.length) {
            weights[i] = this.phases[i].weight;
            ++i;
        }
        return weights;
    }
}

