/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.prov.engine;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.prov.core.eventbus.ProvisioningEventBus;
import org.eclipse.equinox.prov.core.helpers.MultiStatus;
import org.eclipse.equinox.prov.engine.BeginOperationEvent;
import org.eclipse.equinox.prov.engine.CommitOperationEvent;
import org.eclipse.equinox.prov.engine.EngineSession;
import org.eclipse.equinox.prov.engine.Operand;
import org.eclipse.equinox.prov.engine.PhaseSet;
import org.eclipse.equinox.prov.engine.Profile;
import org.eclipse.equinox.prov.engine.RollbackOperationEvent;

public class Engine {
    private final ProvisioningEventBus eventBus;
    private List lockedProfiles = new ArrayList();

    public Engine(ProvisioningEventBus eventBus) {
        this.eventBus = eventBus;
    }

    public MultiStatus perform(Profile profile, PhaseSet phaseSet, Operand[] operands, IProgressMonitor monitor) {
        if (profile == null) {
            throw new IllegalArgumentException("Profile must not be null.");
        }
        if (phaseSet == null) {
            throw new IllegalArgumentException("PhaseSet must not be null.");
        }
        if (operands == null) {
            throw new IllegalArgumentException("Operands must not be null.");
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (operands.length == 0) {
            return new MultiStatus(0, null);
        }
        this.lockProfile(profile);
        try {
            this.eventBus.publishEvent((EventObject)new BeginOperationEvent(profile, phaseSet, operands, this));
            EngineSession session = new EngineSession();
            MultiStatus result = phaseSet.perform(session, profile, operands, monitor);
            if (result.isOK()) {
                this.eventBus.publishEvent((EventObject)new CommitOperationEvent(profile, phaseSet, operands, this));
                session.commit();
            }
            if (result.isErrorOrCancel()) {
                this.eventBus.publishEvent((EventObject)new RollbackOperationEvent(profile, phaseSet, operands, this, (IStatus)result));
                session.rollback();
            }
            MultiStatus multiStatus = result;
            Object var7_8 = null;
            this.unlockProfile(profile);
            return multiStatus;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.unlockProfile(profile);
            throw throwable;
        }
    }

    private synchronized void unlockProfile(Profile profile) {
        this.lockedProfiles.remove(profile);
        this.notify();
    }

    private synchronized void lockProfile(Profile profile) {
        while (this.lockedProfiles.contains(profile)) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        this.lockedProfiles.add(profile);
    }
}

